/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.client.ClientProvider;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.dao.NamingSystemDao;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ReferenceResolverImpl
implements ReferenceResolver,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceResolverImpl.class);
    private final String serverBase;
    private final DaoProvider daoProvider;
    private final ResponseGenerator responseGenerator;
    private final ExceptionHandler exceptionHandler;
    private final ClientProvider clientProvider;
    private final ParameterConverter parameterConverter;

    public ReferenceResolverImpl(String serverBase, DaoProvider daoProvider, ResponseGenerator responseGenerator, ExceptionHandler exceptionHandler, ClientProvider clientProvider, ParameterConverter parameterConverter) {
        this.serverBase = serverBase;
        this.daoProvider = daoProvider;
        this.responseGenerator = responseGenerator;
        this.exceptionHandler = exceptionHandler;
        this.clientProvider = clientProvider;
        this.parameterConverter = parameterConverter;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.daoProvider, "daoProvider");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.clientProvider, "clientProvider");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
    }

    @Override
    public boolean referenceCanBeResolved(ResourceReference reference, Connection connection) {
        return this.referenceCanBeChecked(reference, connection);
    }

    @Override
    public boolean referenceCanBeChecked(ResourceReference reference, Connection connection) {
        Objects.requireNonNull(reference, "reference");
        Objects.requireNonNull(connection, "connection");
        ResourceReference.ReferenceType type = reference.getType(this.serverBase);
        switch (type) {
            case LITERAL_EXTERNAL: 
            case RELATED_ARTEFACT_LITERAL_EXTERNAL_URL: 
            case ATTACHMENT_LITERAL_EXTERNAL_URL: {
                return this.literalExternalReferenceCanBeCheckedAndResolved(reference);
            }
            case LOGICAL: {
                return this.logicalReferenceCanBeCheckedAndResolved(reference, connection);
            }
        }
        return true;
    }

    private boolean logicalReferenceCanBeCheckedAndResolved(ResourceReference reference, Connection connection) {
        ResourceReference.ReferenceType type = reference.getType(this.serverBase);
        if (!ResourceReference.ReferenceType.LOGICAL.equals((Object)type)) {
            throw new IllegalArgumentException("Not a logical reference");
        }
        NamingSystemDao namingSystemDao = this.daoProvider.getNamingSystemDao();
        return this.exceptionHandler.handleSqlException(() -> namingSystemDao.existsWithUniqueIdUriEntryResolvable(connection, reference.getReference().getIdentifier().getSystem()));
    }

    private boolean literalExternalReferenceCanBeCheckedAndResolved(ResourceReference reference) {
        ResourceReference.ReferenceType type = reference.getType(this.serverBase);
        if (!EnumSet.of(ResourceReference.ReferenceType.LITERAL_EXTERNAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL).contains(type)) {
            throw new IllegalArgumentException("Not a literal external reference, related artifact literal external url or attachment literal external url");
        }
        String remoteServerBase = reference.getServerBase(this.serverBase);
        return this.clientProvider.endpointExists(remoteServerBase);
    }

    @Override
    public Optional<Resource> resolveReference(Identity identity, ResourceReference reference, Connection connection) {
        Objects.requireNonNull(identity, "identity");
        Objects.requireNonNull(reference, "reference");
        Objects.requireNonNull(connection, "connection");
        ResourceReference.ReferenceType type = reference.getType(this.serverBase);
        switch (type) {
            case LITERAL_INTERNAL: {
                return this.resolveLiteralInternalReference(reference, connection);
            }
            case LITERAL_EXTERNAL: 
            case RELATED_ARTEFACT_LITERAL_EXTERNAL_URL: 
            case ATTACHMENT_LITERAL_EXTERNAL_URL: {
                return this.resolveLiteralExternalReference(reference);
            }
            case CONDITIONAL: 
            case RELATED_ARTEFACT_CONDITIONAL_URL: 
            case ATTACHMENT_CONDITIONAL_URL: {
                return this.resolveConditionalReference(identity, reference, connection);
            }
            case LOGICAL: {
                return this.resolveLogicalReference(identity, reference, connection);
            }
        }
        throw new IllegalArgumentException("Reference of type " + type + " not supported");
    }

    private void throwIfReferenceTypeUnexpected(ResourceReference.ReferenceType type, ResourceReference.ReferenceType expected) {
        if (!expected.equals((Object)type)) {
            throw new IllegalArgumentException("ReferenceType " + expected + " expected, but was " + type);
        }
    }

    private void throwIfReferenceTypeUnexpected(ResourceReference.ReferenceType type, ResourceReference.ReferenceType ... expected) {
        if (!EnumSet.copyOf(Arrays.asList(expected)).contains(type)) {
            throw new IllegalArgumentException("ReferenceTypes " + Arrays.toString(expected) + " expected, but was " + type);
        }
    }

    private Optional<Resource> resolveLiteralInternalReference(ResourceReference reference, Connection connection) {
        Objects.requireNonNull(reference, "reference");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LITERAL_INTERNAL);
        IdType id = new IdType(reference.getReference().getReference());
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(id.getResourceType());
        if (referenceDao.isEmpty()) {
            logger.warn("Reference target type of reference at {} not supported by this implementation", (Object)reference.getLocation());
            return Optional.empty();
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            logger.warn("Reference target type of reference at {} not supported", (Object)reference.getLocation());
            return Optional.empty();
        }
        Optional<UUID> uuid = this.parameterConverter.toUuid(id.getIdPart());
        if (!id.hasVersionIdPart()) {
            return uuid.flatMap(i -> this.exceptionHandler.catchAndLogSqlAndResourceDeletedExceptionAndIfReturn(() -> {
                if (connection == null) {
                    return d.read((UUID)i);
                }
                return d.readWithTransaction(connection, (UUID)i);
            }, Optional::empty, Optional::empty));
        }
        return uuid.flatMap(i -> this.exceptionHandler.catchAndLogSqlAndResourceDeletedExceptionAndIfReturn(() -> {
            if (connection == null) {
                return d.readVersion((UUID)i, id.getVersionIdPartAsLong());
            }
            return d.readVersionWithTransaction(connection, (UUID)i, id.getVersionIdPartAsLong());
        }, Optional::empty, Optional::empty));
    }

    private Optional<Resource> resolveLiteralExternalReference(ResourceReference reference) {
        Objects.requireNonNull(reference, "reference");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LITERAL_EXTERNAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL);
        String remoteServerBase = reference.getServerBase(this.serverBase);
        Optional<FhirWebserviceClient> client = this.clientProvider.getClient(remoteServerBase);
        if (client.isEmpty()) {
            logger.warn("Literal external reference {} could not be resolved, no remote client for server base {}", (Object)reference.getReference().getReference(), (Object)remoteServerBase);
            return Optional.empty();
        }
        IdType referenceId = new IdType(reference.getReference().getReference());
        logger.debug("Trying to resolve literal external reference {}, at remote server {}", (Object)reference.getReference().getReference(), (Object)remoteServerBase);
        try {
            if (!referenceId.hasVersionIdPart()) {
                return Optional.ofNullable(client.get().read(referenceId.getResourceType(), referenceId.getIdPart()));
            }
            return Optional.ofNullable(client.get().read(referenceId.getResourceType(), referenceId.getIdPart(), referenceId.getVersionIdPart()));
        }
        catch (Exception e) {
            logger.error("Literal external reference {} could not be resolved on remote server {}: {}", new Object[]{reference.getReference().getReference(), remoteServerBase, e.getMessage()});
            if (logger.isDebugEnabled()) {
                logger.debug("Literal external reference " + reference.getReference().getReference() + " could not be resolved on remote server " + remoteServerBase, (Throwable)e);
            }
            return Optional.empty();
        }
    }

    private Optional<Resource> resolveConditionalReference(Identity identity, ResourceReference reference, Connection connection) {
        Objects.requireNonNull(reference, "reference");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.CONDITIONAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_CONDITIONAL_URL, ResourceReference.ReferenceType.ATTACHMENT_CONDITIONAL_URL);
        String referenceValue = reference.getValue();
        String referenceLocation = reference.getLocation();
        UriComponents condition = UriComponentsBuilder.fromUriString((String)referenceValue).build();
        String path = condition.getPath();
        if (path == null || path.isBlank()) {
            logger.warn("Bad conditional reference target '{}' of reference at {}", (Object)referenceValue, (Object)referenceLocation);
            return Optional.empty();
        }
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(path);
        if (referenceDao.isEmpty()) {
            logger.warn("Reference target type of reference at {} not supported by this implementation", (Object)referenceLocation);
            return Optional.empty();
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            logger.warn("Reference target type of reference at {} not supported", (Object)referenceLocation);
            return Optional.empty();
        }
        return this.search(identity, connection, d, reference, (Map<String, List<String>>)condition.getQueryParams(), true);
    }

    private Optional<Resource> resolveLogicalReference(Identity identity, ResourceReference reference, Connection connection) {
        Objects.requireNonNull(reference, "reference");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LOGICAL);
        String targetType = reference.getReference().getType();
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(targetType);
        if (referenceDao.isEmpty()) {
            logger.warn("Reference target type of reference at {} not supported by this implementation", (Object)reference.getLocation());
            return Optional.empty();
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            logger.warn("Reference target type of reference at {} not supported by this implementation", (Object)reference.getLocation());
            return Optional.empty();
        }
        Identifier targetIdentifier = reference.getReference().getIdentifier();
        return this.search(identity, connection, d, reference, Map.of("identifier", Collections.singletonList(targetIdentifier.getSystem() + "|" + targetIdentifier.getValue())), true);
    }

    private Optional<Resource> search(Identity identity, Connection connection, ResourceDao<?> referenceTargetDao, ResourceReference resourceReference, Map<String, List<String>> queryParameters, boolean logicalNotConditional) {
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("Query contains parameter not applicable in this resolve reference context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery<?> query = referenceTargetDao.createSearchQuery(identity, 1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
            logger.warn("{} reference {} at {} in resource contains unsupported queryparameter{} {}", new Object[]{logicalNotConditional ? "Logical" : "Conditional", queryParameters, resourceReference.getLocation(), unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString});
            return Optional.empty();
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> {
            if (connection == null) {
                return referenceTargetDao.search(query);
            }
            return referenceTargetDao.searchWithTransaction(connection, query);
        });
        if (result.getTotal() <= 0) {
            if (logicalNotConditional) {
                logger.warn("Reference target by identifier '{}|{}' of reference at {} in resource", new Object[]{resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation()});
            } else {
                logger.warn("Reference target by condition '{}' of reference at {} in resource", (Object)UriComponentsBuilder.newInstance().path(referenceTargetDao.getResourceTypeName()).replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)resourceReference.getLocation());
            }
            return Optional.empty();
        }
        if (result.getTotal() == 1) {
            return Optional.of((Resource)result.getPartialResult().get(0));
        }
        int overallCount = result.getTotal();
        if (logicalNotConditional) {
            logger.warn("Found {} matches for reference target by identifier '{}|{}' of reference at {} in resource", new Object[]{overallCount, resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation()});
        } else {
            logger.warn("Found {} matches for reference target by condition '{}' of reference at {} in resource", new Object[]{overallCount, UriComponentsBuilder.newInstance().path(referenceTargetDao.getResourceTypeName()).replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), resourceReference.getLocation()});
        }
        return Optional.empty();
    }

    @Override
    public Optional<OperationOutcome> checkLiteralInternalReference(Resource resource, ResourceReference resourceReference, Connection connection) throws IllegalArgumentException {
        return this.checkLiteralInternalReference(resource, resourceReference, connection, null);
    }

    @Override
    public Optional<OperationOutcome> checkLiteralInternalReference(Resource resource, ResourceReference reference, Connection connection, Integer bundleIndex) throws IllegalArgumentException {
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(reference, "reference");
        Objects.requireNonNull(connection, "connection");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LITERAL_INTERNAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_INTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_INTERNAL_URL);
        IdType id = new IdType(reference.getValue());
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(id.getResourceType());
        if (referenceDao.isEmpty()) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByImplementation(bundleIndex, resource, reference));
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByResource(bundleIndex, resource, reference));
        }
        boolean exists = this.exceptionHandler.handleSqlException(() -> d.existsNotDeletedWithTransaction(connection, id.getIdPart(), id.getVersionIdPart()));
        if (!exists) {
            return Optional.of(this.responseGenerator.referenceTargetNotFoundLocally(bundleIndex, resource, reference));
        }
        return Optional.empty();
    }

    @Override
    public Optional<OperationOutcome> checkLiteralExternalReference(Resource resource, ResourceReference resourceReference) throws IllegalArgumentException {
        return this.checkLiteralExternalReference(resource, resourceReference, null);
    }

    @Override
    public Optional<OperationOutcome> checkLiteralExternalReference(Resource resource, ResourceReference reference, Integer bundleIndex) throws IllegalArgumentException {
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(reference, "reference");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LITERAL_EXTERNAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL);
        String remoteServerBase = reference.getServerBase(this.serverBase);
        String referenceValue = reference.getValue();
        Optional<FhirWebserviceClient> client = this.clientProvider.getClient(remoteServerBase);
        if (client.isEmpty()) {
            logger.error("Literal external reference {} could not be resolved, no remote client for server base {}", (Object)referenceValue, (Object)remoteServerBase);
            return Optional.of(this.responseGenerator.noEndpointFoundForLiteralExternalReference(bundleIndex, resource, reference));
        }
        IdType referenceId = new IdType(referenceValue);
        logger.debug("Trying to resolve literal external reference {}, at remote server {}", (Object)referenceValue, (Object)remoteServerBase);
        try {
            if (client.get().exists(referenceId)) {
                return Optional.empty();
            }
            logger.warn("Literal external reference {} could not be resolved, resource not found on remote server {}", (Object)referenceValue, (Object)remoteServerBase);
            return Optional.of(this.responseGenerator.referenceTargetNotFoundRemote(bundleIndex, resource, reference, remoteServerBase));
        }
        catch (Exception e) {
            logger.error("Literal external reference {} could not be resolved on remote server {}: {}", new Object[]{referenceValue, remoteServerBase, e.getMessage()});
            if (logger.isDebugEnabled()) {
                logger.debug("Literal external reference " + referenceValue + " could not be resolved on remote server " + remoteServerBase, (Throwable)e);
            }
            return Optional.of(this.responseGenerator.referenceTargetCouldNotBeResolvedOnRemote(bundleIndex, resource, reference, remoteServerBase));
        }
    }

    @Override
    public Optional<OperationOutcome> checkConditionalReference(Identity identity, Resource resource, ResourceReference reference, Connection connection, Integer bundleIndex) throws IllegalArgumentException {
        Objects.requireNonNull(identity, "identity");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(reference, "reference");
        Objects.requireNonNull(connection, "connection");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.CONDITIONAL);
        UriComponents condition = UriComponentsBuilder.fromUriString((String)reference.getReference().getReference()).build();
        String path = condition.getPath();
        if (path == null || path.isBlank()) {
            return Optional.of(this.responseGenerator.referenceTargetBadCondition(bundleIndex, resource, reference));
        }
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(path);
        if (referenceDao.isEmpty()) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByImplementation(bundleIndex, resource, reference));
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByResource(bundleIndex, resource, reference));
        }
        return this.search(identity, resource, bundleIndex, connection, d, reference, (Map<String, List<String>>)condition.getQueryParams(), true);
    }

    @Override
    public Optional<OperationOutcome> checkLogicalReference(Identity identity, Resource resource, ResourceReference resourceReference, Connection connection) throws IllegalArgumentException {
        return this.checkLogicalReference(identity, resource, resourceReference, connection, null);
    }

    @Override
    public Optional<OperationOutcome> checkLogicalReference(Identity identity, Resource resource, ResourceReference reference, Connection connection, Integer bundleIndex) throws IllegalArgumentException {
        Objects.requireNonNull(identity, "identity");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(reference, "reference");
        Objects.requireNonNull(connection, "connection");
        this.throwIfReferenceTypeUnexpected(reference.getType(this.serverBase), ResourceReference.ReferenceType.LOGICAL);
        String targetType = reference.getReference().getType();
        Optional<ResourceDao<?>> referenceDao = this.daoProvider.getDao(targetType);
        if (referenceDao.isEmpty()) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByImplementation(bundleIndex, resource, reference));
        }
        ResourceDao<?> d = referenceDao.get();
        if (!reference.supportsType(d.getResourceType())) {
            return Optional.of(this.responseGenerator.referenceTargetTypeNotSupportedByResource(bundleIndex, resource, reference));
        }
        Identifier targetIdentifier = reference.getReference().getIdentifier();
        return this.search(identity, resource, bundleIndex, connection, d, reference, Map.of("identifier", Collections.singletonList(targetIdentifier.getSystem() + "|" + targetIdentifier.getValue())), true);
    }

    private Optional<OperationOutcome> search(Identity identity, Resource resource, Integer bundleIndex, Connection connection, ResourceDao<?> referenceTargetDao, ResourceReference resourceReference, Map<String, List<String>> queryParameters, boolean logicalNotConditional) {
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("Query contains parameter not applicable in this resolve reference context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery<?> query = referenceTargetDao.createSearchQuery(identity, 1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            return Optional.of(this.responseGenerator.badReference(logicalNotConditional, bundleIndex, resource, resourceReference, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), unsupportedQueryParameters));
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> referenceTargetDao.searchWithTransaction(connection, query));
        if (result.getTotal() <= 0) {
            if (logicalNotConditional) {
                return Optional.of(this.responseGenerator.referenceTargetNotFoundLocallyByIdentifier(bundleIndex, resource, resourceReference));
            }
            return Optional.of(this.responseGenerator.referenceTargetNotFoundLocallyByCondition(bundleIndex, resource, resourceReference));
        }
        if (result.getTotal() == 1) {
            return Optional.empty();
        }
        if (logicalNotConditional) {
            return Optional.of(this.responseGenerator.referenceTargetMultipleMatchesLocallyByIdentifier(bundleIndex, resource, resourceReference, result.getTotal()));
        }
        return Optional.of(this.responseGenerator.referenceTargetMultipleMatchesLocallyByCondition(bundleIndex, resource, resourceReference, result.getTotal()));
    }
}

