/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import dev.dsf.fhir.service.InitialDataMigrator;
import dev.dsf.fhir.service.migration.MigrationJob;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialDataMigratorImpl
implements InitialDataMigrator {
    private static final Logger logger = LoggerFactory.getLogger(InitialDataMigratorImpl.class);
    private final List<MigrationJob> migrationJobs = new ArrayList<MigrationJob>();

    public InitialDataMigratorImpl(List<MigrationJob> migrationJobs) {
        if (migrationJobs != null) {
            this.migrationJobs.addAll(migrationJobs);
        }
    }

    @Override
    public void execute() throws Exception {
        logger.info("Executing initial data migration jobs ...");
        for (MigrationJob job : this.migrationJobs) {
            try {
                logger.debug("Executing initial data migration job: {}", (Object)job.getClass().getName());
                job.execute();
            }
            catch (Exception exception) {
                logger.warn("Initial data migration job '{}' failed with error: {}", (Object)job.getClass().getName(), (Object)exception.getMessage());
                throw new RuntimeException(exception);
            }
        }
        logger.info("Executing initial data migration jobs [Done]");
    }
}

