/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractUrlAndVersionParameter<R extends MetadataResource>
extends AbstractCanonicalUrlParameter<R> {
    public static final String PARAMETER_NAME = "url";
    private final String resourceColumn;

    public AbstractUrlAndVersionParameter(String resourceColumn) {
        super(PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    public String getFilterQuery() {
        String versionSubQuery = this.hasVersion() ? " AND " + this.resourceColumn + "->>'version' = ?" : "";
        switch (this.valueAndType.type) {
            case PRECISE: {
                return this.resourceColumn + "->>'url' = ?" + versionSubQuery;
            }
            case BELOW: {
                return this.resourceColumn + "->>'url' LIKE ?" + versionSubQuery;
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return this.hasVersion() ? 2 : 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        if (subqueryParameterIndex == 1) {
            switch (this.valueAndType.type) {
                case PRECISE: {
                    statement.setString(parameterIndex, this.valueAndType.url);
                    return;
                }
                case BELOW: {
                    statement.setString(parameterIndex, this.valueAndType.url + "%");
                    return;
                }
            }
            return;
        }
        if (subqueryParameterIndex == 2) {
            statement.setString(parameterIndex, this.valueAndType.version);
        }
    }

    protected abstract boolean instanceOf(Resource var1);

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!this.instanceOf(resource)) {
            return false;
        }
        MetadataResource mRes = (MetadataResource)resource;
        switch (this.valueAndType.type) {
            case PRECISE: {
                return Objects.equals(mRes.getUrl(), this.valueAndType.url) && (this.valueAndType.version == null || Objects.equals(mRes.getVersion(), this.valueAndType.version));
            }
            case BELOW: {
                return mRes.getUrl() != null && mRes.getUrl().startsWith(this.valueAndType.url) && (this.valueAndType.version == null || Objects.equals(mRes.getVersion(), this.valueAndType.version));
            }
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->>'url'" + sortDirectionWithSpacePrefix;
    }
}

