/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import java.util.List;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractStringParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    protected StringValueAndSearchType valueAndType;

    public static List<String> getNameModifiers() {
        return List.of(StringSearchType.EXACT.modifier, StringSearchType.CONTAINS.modifier);
    }

    public AbstractStringParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        if ((this.parameterName + StringSearchType.STARTS_WITH.modifier).equals(queryParameterName)) {
            this.valueAndType = new StringValueAndSearchType(queryParameterValue, StringSearchType.STARTS_WITH);
        } else if ((this.parameterName + StringSearchType.EXACT.modifier).equals(queryParameterName)) {
            this.valueAndType = new StringValueAndSearchType(queryParameterValue, StringSearchType.EXACT);
        } else if ((this.parameterName + StringSearchType.CONTAINS.modifier).equals(queryParameterName)) {
            this.valueAndType = new StringValueAndSearchType(queryParameterValue, StringSearchType.CONTAINS);
        }
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return this.parameterName + this.valueAndType.type.modifier;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.valueAndType.value;
    }

    public static enum StringSearchType {
        STARTS_WITH(""),
        EXACT(":exact"),
        CONTAINS(":contains");

        public final String modifier;

        private StringSearchType(String modifier) {
            this.modifier = modifier;
        }
    }

    protected static class StringValueAndSearchType {
        public final String value;
        public final StringSearchType type;

        private StringValueAndSearchType(String value, StringSearchType type) {
            this.value = value;
            this.type = type;
        }
    }
}

