/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractCanonicalUrlParameter<R extends Resource>
extends AbstractSearchParameter<R> {
    protected CanonicalUrlAndSearchType valueAndType;

    public static List<String> getNameModifiers() {
        return Collections.singletonList(UriSearchType.BELOW.modifier);
    }

    public AbstractCanonicalUrlParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        if ((this.parameterName + UriSearchType.PRECISE.modifier).equals(queryParameterName)) {
            this.valueAndType = this.toValueAndType(queryParameterValue, UriSearchType.PRECISE);
        } else if ((this.parameterName + UriSearchType.BELOW.modifier).equals(queryParameterName)) {
            this.valueAndType = this.toValueAndType(queryParameterValue, UriSearchType.BELOW);
        }
    }

    private CanonicalUrlAndSearchType toValueAndType(String value, UriSearchType type) {
        if (value != null && !value.isBlank()) {
            String[] split = value.split("[|]");
            if (split.length == 1) {
                return new CanonicalUrlAndSearchType(split[0], null, type);
            }
            if (split.length == 2) {
                return new CanonicalUrlAndSearchType(split[0], split[1], type);
            }
        }
        return null;
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    protected boolean hasVersion() {
        return this.isDefined() && this.valueAndType.version != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return this.parameterName + this.valueAndType.type.modifier;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.valueAndType.url + (String)(this.hasVersion() ? "|" + this.valueAndType.version : "");
    }

    public static enum UriSearchType {
        PRECISE(""),
        BELOW(":below");

        public final String modifier;

        private UriSearchType(String modifier) {
            this.modifier = modifier;
        }
    }

    protected static class CanonicalUrlAndSearchType {
        public final String url;
        public final String version;
        public final UriSearchType type;

        private CanonicalUrlAndSearchType(String url, String version, UriSearchType type) {
            this.url = url;
            this.version = version;
            this.type = type;
        }
    }
}

