/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Subscription;

@SearchQueryParameter.SearchParameterDefinition(name="criteria", definition="http://hl7.org/fhir/SearchParameter/Subscription-criteria", type=Enumerations.SearchParamType.STRING, documentation="The search rules used to determine when to send a notification (always matches exact)")
public class SubscriptionCriteria
extends AbstractStringParameter<Subscription> {
    public static final String PARAMETER_NAME = "criteria";

    public SubscriptionCriteria() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return "subscription->>'criteria' = ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.valueAndType.value);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Subscription)) {
            return false;
        }
        Subscription s = (Subscription)resource;
        return Objects.equals(this.valueAndType.value, s.getCriteria());
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "subscription->>'criteria'" + sortDirectionWithSpacePrefix;
    }
}

