/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/ResearchStudy-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="Business Identifier for study")
public class ResearchStudyIdentifier
extends AbstractIdentifierParameter<ResearchStudy> {
    public static final String RESOURCE_COLUMN = "research_study";

    public ResearchStudyIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy r = (ResearchStudy)resource;
        return this.identifierMatches(r.getIdentifier());
    }
}

