/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Patient-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="A patient identifier")
public class PatientIdentifier
extends AbstractIdentifierParameter<Patient> {
    public static final String RESOURCE_COLUMN = "patient";

    public PatientIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Patient)) {
            return false;
        }
        Patient p = (Patient)resource;
        return this.identifierMatches(p.getIdentifier());
    }
}

