/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/conformance-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the code system")
public class CodeSystemIdentifier
extends AbstractIdentifierParameter<CodeSystem> {
    public static final String RESOURCE_COLUMN = "code_system";

    public CodeSystemIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof CodeSystem)) {
            return false;
        }
        CodeSystem c = (CodeSystem)resource;
        return this.identifierMatches(c.getIdentifier());
    }
}

