/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="name", definition="http://hl7.org/fhir/SearchParameter/ActivityDefinition-name", type=Enumerations.SearchParamType.STRING, documentation="Computationally friendly name of the activity definition")
public class ActivityDefinitionName
extends AbstractStringParameter<ActivityDefinition> {
    public static final String PARAMETER_NAME = "name";

    public ActivityDefinitionName() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case STARTS_WITH: 
            case CONTAINS: {
                return "lower(activity_definition->>'name') LIKE ?";
            }
            case EXACT: {
                return "activity_definition->>'name' = ?";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                statement.setString(parameterIndex, this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case CONTAINS: {
                statement.setString(parameterIndex, "%" + this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case EXACT: {
                statement.setString(parameterIndex, this.valueAndType.value);
                return;
            }
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition e = (ActivityDefinition)resource;
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                return e.getName() != null && e.getName().toLowerCase().startsWith(this.valueAndType.value.toLowerCase());
            }
            case CONTAINS: {
                return e.getName() != null && e.getName().toLowerCase().contains(this.valueAndType.value.toLowerCase());
            }
            case EXACT: {
                return Objects.equals(e.getName(), this.valueAndType.value);
            }
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "activity_definition->>'name'" + sortDirectionWithSpacePrefix;
    }
}

