/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

public class SearchQueryParameterError {
    private final SearchQueryParameterErrorType type;
    private final String parameterName;
    private final String parameterValue;
    private final Exception exception;
    private final String message;

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, String parameterValue) {
        this(type, parameterName, parameterValue, null, null);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, String parameterValue, String message) {
        this(type, parameterName, parameterValue, null, message);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, String parameterValue, Exception exception) {
        this(type, parameterName, parameterValue, exception, null);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, String parameterValue, Exception exception, String message) {
        this.type = type;
        this.parameterName = parameterName;
        this.parameterValue = parameterValue;
        this.exception = exception;
        this.message = message;
    }

    public SearchQueryParameterErrorType getType() {
        return this.type;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("parameter: ");
        b.append(this.parameterName);
        b.append(", error: ");
        b.append((Object)this.type);
        if (this.exception != null || this.message != null) {
            b.append(", message: '");
            if (this.exception != null) {
                b.append(this.exception.getClass().getSimpleName());
                b.append(" - ");
                b.append(this.exception.getMessage());
                b.append("'");
            } else if (this.message != null) {
                b.append(this.message);
                b.append("'");
            }
        }
        if (this.parameterValue != null) {
            b.append(", value: ");
            b.append(this.parameterValue);
        }
        return b.toString();
    }

    public static enum SearchQueryParameterErrorType {
        UNSUPPORTED_PARAMETER,
        UNSUPPORTED_NUMBER_OF_VALUES,
        UNPARSABLE_VALUE;

    }
}

