/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.provider;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.fhir.dao.ActivityDefinitionDao;
import dev.dsf.fhir.dao.BinaryDao;
import dev.dsf.fhir.dao.BundleDao;
import dev.dsf.fhir.dao.CodeSystemDao;
import dev.dsf.fhir.dao.DocumentReferenceDao;
import dev.dsf.fhir.dao.EndpointDao;
import dev.dsf.fhir.dao.GroupDao;
import dev.dsf.fhir.dao.HealthcareServiceDao;
import dev.dsf.fhir.dao.LibraryDao;
import dev.dsf.fhir.dao.LocationDao;
import dev.dsf.fhir.dao.MeasureDao;
import dev.dsf.fhir.dao.MeasureReportDao;
import dev.dsf.fhir.dao.NamingSystemDao;
import dev.dsf.fhir.dao.OrganizationAffiliationDao;
import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.dao.PatientDao;
import dev.dsf.fhir.dao.PractitionerDao;
import dev.dsf.fhir.dao.PractitionerRoleDao;
import dev.dsf.fhir.dao.ProvenanceDao;
import dev.dsf.fhir.dao.QuestionnaireDao;
import dev.dsf.fhir.dao.QuestionnaireResponseDao;
import dev.dsf.fhir.dao.ReadAccessDao;
import dev.dsf.fhir.dao.ResearchStudyDao;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.SubscriptionDao;
import dev.dsf.fhir.dao.TaskDao;
import dev.dsf.fhir.dao.ValueSetDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.InitializingBean;

public class DaoProviderImpl
implements DaoProvider,
InitializingBean {
    private final DataSource dataSource;
    private final ActivityDefinitionDao activityDefinitionDao;
    private final BinaryDao binaryDao;
    private final BundleDao bundleDao;
    private final DocumentReferenceDao documentReferenceDao;
    private final CodeSystemDao codeSystemDao;
    private final EndpointDao endpointDao;
    private final GroupDao groupDao;
    private final HealthcareServiceDao healthcareServiceDao;
    private final LibraryDao libraryDao;
    private final LocationDao locationDao;
    private final MeasureDao measureDao;
    private final MeasureReportDao measureReportDao;
    private final NamingSystemDao namingSystemDao;
    private final OrganizationDao organizationDao;
    private final OrganizationAffiliationDao organizationAffiliationDao;
    private final PatientDao patientDao;
    private final PractitionerDao practitionerDao;
    private final PractitionerRoleDao practitionerRoleDao;
    private final ProvenanceDao provenanceDao;
    private final QuestionnaireDao questionnaireDao;
    private final QuestionnaireResponseDao questionnaireResponseDao;
    private final ResearchStudyDao researchStudyDao;
    private final StructureDefinitionDao structureDefinitionDao;
    private final StructureDefinitionDao structureDefinitionSnapshotDao;
    private final SubscriptionDao subscriptionDao;
    private final TaskDao taskDao;
    private final ValueSetDao valueSetDao;
    private final ReadAccessDao readAccessDao;
    private final Map<Class<? extends Resource>, ResourceDao<?>> daosByResourceClass = new HashMap();
    private final Map<String, ResourceDao<?>> daosByResourceTypeName = new HashMap();

    public DaoProviderImpl(DataSource dataSource, ActivityDefinitionDao activityDefinitionDao, BinaryDao binaryDao, BundleDao bundleDao, CodeSystemDao codeSystemDao, DocumentReferenceDao documentReferenceDao, EndpointDao endpointDao, GroupDao groupDao, HealthcareServiceDao healthcareServiceDao, LibraryDao libraryDao, LocationDao locationDao, MeasureDao measureDao, MeasureReportDao measureReportDao, NamingSystemDao namingSystemDao, OrganizationDao organizationDao, OrganizationAffiliationDao organizationAffiliationDao, PatientDao patientDao, PractitionerDao practitionerDao, PractitionerRoleDao practitionerRoleDao, ProvenanceDao provenanceDao, QuestionnaireDao questionnaireDao, QuestionnaireResponseDao questionnaireResponseDao, ResearchStudyDao researchStudyDao, StructureDefinitionDao structureDefinitionDao, StructureDefinitionDao structureDefinitionSnapshotDao, SubscriptionDao subscriptionDao, TaskDao taskDao, ValueSetDao valueSetDao, ReadAccessDao readAccessDao) {
        this.dataSource = dataSource;
        this.activityDefinitionDao = activityDefinitionDao;
        this.binaryDao = binaryDao;
        this.bundleDao = bundleDao;
        this.codeSystemDao = codeSystemDao;
        this.documentReferenceDao = documentReferenceDao;
        this.endpointDao = endpointDao;
        this.groupDao = groupDao;
        this.healthcareServiceDao = healthcareServiceDao;
        this.libraryDao = libraryDao;
        this.locationDao = locationDao;
        this.measureDao = measureDao;
        this.measureReportDao = measureReportDao;
        this.namingSystemDao = namingSystemDao;
        this.organizationDao = organizationDao;
        this.organizationAffiliationDao = organizationAffiliationDao;
        this.patientDao = patientDao;
        this.practitionerDao = practitionerDao;
        this.practitionerRoleDao = practitionerRoleDao;
        this.provenanceDao = provenanceDao;
        this.questionnaireDao = questionnaireDao;
        this.questionnaireResponseDao = questionnaireResponseDao;
        this.researchStudyDao = researchStudyDao;
        this.structureDefinitionDao = structureDefinitionDao;
        this.structureDefinitionSnapshotDao = structureDefinitionSnapshotDao;
        this.subscriptionDao = subscriptionDao;
        this.taskDao = taskDao;
        this.valueSetDao = valueSetDao;
        this.readAccessDao = readAccessDao;
        this.daosByResourceClass.put(ActivityDefinition.class, activityDefinitionDao);
        this.daosByResourceClass.put(Binary.class, binaryDao);
        this.daosByResourceClass.put(Bundle.class, bundleDao);
        this.daosByResourceClass.put(CodeSystem.class, codeSystemDao);
        this.daosByResourceClass.put(DocumentReference.class, documentReferenceDao);
        this.daosByResourceClass.put(Endpoint.class, endpointDao);
        this.daosByResourceClass.put(Group.class, groupDao);
        this.daosByResourceClass.put(HealthcareService.class, healthcareServiceDao);
        this.daosByResourceClass.put(Library.class, libraryDao);
        this.daosByResourceClass.put(Location.class, locationDao);
        this.daosByResourceClass.put(Measure.class, measureDao);
        this.daosByResourceClass.put(MeasureReport.class, measureReportDao);
        this.daosByResourceClass.put(NamingSystem.class, namingSystemDao);
        this.daosByResourceClass.put(Organization.class, organizationDao);
        this.daosByResourceClass.put(OrganizationAffiliation.class, organizationAffiliationDao);
        this.daosByResourceClass.put(Patient.class, patientDao);
        this.daosByResourceClass.put(Practitioner.class, practitionerDao);
        this.daosByResourceClass.put(PractitionerRole.class, practitionerRoleDao);
        this.daosByResourceClass.put(Provenance.class, provenanceDao);
        this.daosByResourceClass.put(Questionnaire.class, questionnaireDao);
        this.daosByResourceClass.put(QuestionnaireResponse.class, questionnaireResponseDao);
        this.daosByResourceClass.put(ResearchStudy.class, researchStudyDao);
        this.daosByResourceClass.put(StructureDefinition.class, structureDefinitionDao);
        this.daosByResourceClass.put(Subscription.class, subscriptionDao);
        this.daosByResourceClass.put(Task.class, taskDao);
        this.daosByResourceClass.put(ValueSet.class, valueSetDao);
        this.daosByResourceClass.forEach((k, v) -> this.daosByResourceTypeName.put(k.getAnnotation(ResourceDef.class).name(), (ResourceDao<?>)v));
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.activityDefinitionDao, "activityDefinitionDao");
        Objects.requireNonNull(this.binaryDao, "binaryDao");
        Objects.requireNonNull(this.bundleDao, "bundleDao");
        Objects.requireNonNull(this.codeSystemDao, "codeSystemDao");
        Objects.requireNonNull(this.documentReferenceDao, "documentReferenceDao");
        Objects.requireNonNull(this.endpointDao, "endpointDao");
        Objects.requireNonNull(this.groupDao, "groupDao");
        Objects.requireNonNull(this.healthcareServiceDao, "healthcareServiceDao");
        Objects.requireNonNull(this.libraryDao, "libraryDao");
        Objects.requireNonNull(this.locationDao, "locationDao");
        Objects.requireNonNull(this.measureDao, "measureDao");
        Objects.requireNonNull(this.measureReportDao, "measureReportDao");
        Objects.requireNonNull(this.namingSystemDao, "namingSystemDao");
        Objects.requireNonNull(this.organizationDao, "organizationDao");
        Objects.requireNonNull(this.organizationAffiliationDao, "organizationAffiliationDao");
        Objects.requireNonNull(this.patientDao, "patientDao");
        Objects.requireNonNull(this.practitionerDao, "practitionerDao");
        Objects.requireNonNull(this.practitionerRoleDao, "practitionerRoleDao");
        Objects.requireNonNull(this.provenanceDao, "provenanceDao");
        Objects.requireNonNull(this.questionnaireDao, "questionnaireDao");
        Objects.requireNonNull(this.questionnaireResponseDao, "questionnaireResponseDao");
        Objects.requireNonNull(this.researchStudyDao, "researchStudyDao");
        Objects.requireNonNull(this.structureDefinitionDao, "structureDefinitionDao");
        Objects.requireNonNull(this.structureDefinitionSnapshotDao, "structureDefinitionSnapshotDao");
        Objects.requireNonNull(this.subscriptionDao, "subscriptionDao");
        Objects.requireNonNull(this.taskDao, "taskDao");
        Objects.requireNonNull(this.valueSetDao, "valueSetDao");
    }

    @Override
    public Connection newReadOnlyAutoCommitTransaction() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        if (!connection.isReadOnly() || !connection.getAutoCommit()) {
            throw new IllegalStateException("read only, auto commit connection expected from data source");
        }
        return connection;
    }

    @Override
    public Connection newReadWriteTransaction() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setReadOnly(false);
        connection.setTransactionIsolation(4);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public ActivityDefinitionDao getActivityDefinitionDao() {
        return this.activityDefinitionDao;
    }

    @Override
    public BinaryDao getBinaryDao() {
        return this.binaryDao;
    }

    @Override
    public BundleDao getBundleDao() {
        return this.bundleDao;
    }

    @Override
    public DocumentReferenceDao getDocumentReferenceDao() {
        return this.documentReferenceDao;
    }

    @Override
    public CodeSystemDao getCodeSystemDao() {
        return this.codeSystemDao;
    }

    @Override
    public EndpointDao getEndpointDao() {
        return this.endpointDao;
    }

    @Override
    public GroupDao getGroupDao() {
        return this.groupDao;
    }

    @Override
    public HealthcareServiceDao getHealthcareServiceDao() {
        return this.healthcareServiceDao;
    }

    @Override
    public LibraryDao getLibraryDao() {
        return this.libraryDao;
    }

    @Override
    public LocationDao getLocationDao() {
        return this.locationDao;
    }

    @Override
    public MeasureDao getMeasureDao() {
        return this.measureDao;
    }

    @Override
    public MeasureReportDao getMeasureReportDao() {
        return this.measureReportDao;
    }

    @Override
    public NamingSystemDao getNamingSystemDao() {
        return this.namingSystemDao;
    }

    @Override
    public OrganizationDao getOrganizationDao() {
        return this.organizationDao;
    }

    @Override
    public OrganizationAffiliationDao getOrganizationAffiliationDao() {
        return this.organizationAffiliationDao;
    }

    @Override
    public PatientDao getPatientDao() {
        return this.patientDao;
    }

    @Override
    public PractitionerDao getPractitionerDao() {
        return this.practitionerDao;
    }

    @Override
    public PractitionerRoleDao getPractitionerRoleDao() {
        return this.practitionerRoleDao;
    }

    @Override
    public ProvenanceDao getProvenanceDao() {
        return this.provenanceDao;
    }

    @Override
    public QuestionnaireDao getQuestionnaireDao() {
        return this.questionnaireDao;
    }

    @Override
    public QuestionnaireResponseDao getQuestionnaireResponseDao() {
        return this.questionnaireResponseDao;
    }

    @Override
    public ResearchStudyDao getResearchStudyDao() {
        return this.researchStudyDao;
    }

    @Override
    public StructureDefinitionDao getStructureDefinitionDao() {
        return this.structureDefinitionDao;
    }

    @Override
    public StructureDefinitionDao getStructureDefinitionSnapshotDao() {
        return this.structureDefinitionSnapshotDao;
    }

    @Override
    public SubscriptionDao getSubscriptionDao() {
        return this.subscriptionDao;
    }

    @Override
    public TaskDao getTaskDao() {
        return this.taskDao;
    }

    @Override
    public ValueSetDao getValueSetDao() {
        return this.valueSetDao;
    }

    @Override
    public <R extends Resource> Optional<? extends ResourceDao<R>> getDao(Class<R> resourceClass) {
        ResourceDao<?> value = this.daosByResourceClass.get(resourceClass);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<ResourceDao<?>> getDao(String resourceTypeName) {
        ResourceDao<?> value = this.daosByResourceTypeName.get(resourceTypeName);
        return Optional.ofNullable(value);
    }

    @Override
    public ReadAccessDao getReadAccessDao() {
        return this.readAccessDao;
    }
}

