/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.dao.jdbc.AbstractResourceDaoJdbc;
import dev.dsf.fhir.search.filter.OrganizationIdentityFilter;
import dev.dsf.fhir.search.parameters.OrganizationActive;
import dev.dsf.fhir.search.parameters.OrganizationEndpoint;
import dev.dsf.fhir.search.parameters.OrganizationIdentifier;
import dev.dsf.fhir.search.parameters.OrganizationName;
import dev.dsf.fhir.search.parameters.OrganizationType;
import dev.dsf.fhir.search.parameters.rev.include.EndpointOrganizationRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.OrganizationAffiliationParticipatingOrganizationRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.OrganizationAffiliationPrimaryOrganizationRevInclude;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Organization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationDaoJdbc
extends AbstractResourceDaoJdbc<Organization>
implements OrganizationDao {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationDaoJdbc.class);

    public OrganizationDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext) {
        super(dataSource, permanentDeleteDataSource, fhirContext, Organization.class, "organizations", "organization", "organization_id", OrganizationIdentityFilter::new, Arrays.asList(OrganizationDaoJdbc.factory("active", OrganizationActive::new), OrganizationDaoJdbc.factory("endpoint", OrganizationEndpoint::new, OrganizationEndpoint.getNameModifiers(), OrganizationEndpoint::new, OrganizationEndpoint.getIncludeParameterValues()), OrganizationDaoJdbc.factory("identifier", OrganizationIdentifier::new, OrganizationIdentifier.getNameModifiers()), OrganizationDaoJdbc.factory("name", OrganizationName::new, OrganizationName.getNameModifiers()), OrganizationDaoJdbc.factory("type", OrganizationType::new, OrganizationType.getNameModifiers())), Arrays.asList(OrganizationDaoJdbc.factory(EndpointOrganizationRevInclude::new, EndpointOrganizationRevInclude.getRevIncludeParameterValues()), OrganizationDaoJdbc.factory(OrganizationAffiliationPrimaryOrganizationRevInclude::new, OrganizationAffiliationPrimaryOrganizationRevInclude.getRevIncludeParameterValues()), OrganizationDaoJdbc.factory(OrganizationAffiliationParticipatingOrganizationRevInclude::new, OrganizationAffiliationParticipatingOrganizationRevInclude.getRevIncludeParameterValues())));
    }

    @Override
    protected Organization copy(Organization resource) {
        return resource.copy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<Organization> readActiveNotDeletedByThumbprint(String thumbprintHex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<Organization> readActiveNotDeletedByIdentifier(String identifierValue) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean existsNotDeletedByThumbprintWithTransaction(Connection connection, String thumbprintHex) throws SQLException {
        if (thumbprintHex == null || thumbprintHex.isBlank()) {
            return false;
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT organization FROM current_organizations WHERE organization->'extension' @> ?::jsonb");){
            boolean bl;
            block17: {
                ResultSet result;
                block15: {
                    boolean bl2;
                    block16: {
                        String search = "[{\"url\": \"http://dsf.dev/fhir/StructureDefinition/extension-certificate-thumbprint\", \"valueString\": \"" + thumbprintHex + "\"}]";
                        statement.setString(1, search);
                        logger.trace("Executing query '{}'", (Object)statement);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block15;
                            Organization organization = (Organization)this.getResource(result, 1);
                            logger.debug("Organization with thumprint {}, IdPart {} found", (Object)thumbprintHex, (Object)organization.getIdElement().getIdPart());
                            bl2 = true;
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                logger.debug("Organization with thumprint {} not found", (Object)thumbprintHex);
                bl = false;
                if (result == null) break block17;
                result.close();
            }
            return bl;
        }
    }
}

