/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.command.AbstractCommand;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ReadCommand
extends AbstractCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(ReadCommand.class);
    private final int defaultPageCount;
    private final DaoProvider daoProvider;
    private final ParameterConverter parameterConverter;
    private final ResponseGenerator responseGenerator;
    private final ExceptionHandler exceptionHandler;
    private final ReferenceCleaner referenceCleaner;
    private final PreferHandlingType handlingType;
    private String resourceTypeName;
    private Bundle multipleResult;
    private Resource singleResult;
    private OperationOutcome singleResultSearchWarning;
    private Response responseResult;
    private boolean search;

    public ReadCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, int defaultPageCount, DaoProvider daoProvider, ParameterConverter parameterConverter, ResponseGenerator responseGenerator, ExceptionHandler exceptionHandler, ReferenceCleaner referenceCleaner, PreferHandlingType handlingType) {
        super(5, index, identity, returnType, bundle, entry, serverBase, authorizationHelper);
        this.defaultPageCount = defaultPageCount;
        this.daoProvider = daoProvider;
        this.parameterConverter = parameterConverter;
        this.responseGenerator = responseGenerator;
        this.exceptionHandler = exceptionHandler;
        this.referenceCleaner = referenceCleaner;
        this.handlingType = handlingType;
    }

    @Override
    public void preExecute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) {
    }

    @Override
    public void execute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) throws SQLException, WebApplicationException {
        String requestUrl = this.entry.getRequest().getUrl();
        logger.debug("Executing request for url {}", (Object)requestUrl);
        if (requestUrl.startsWith("urn:uuid:")) {
            requestUrl = idTranslationTable.getOrDefault(requestUrl, new IdType(requestUrl)).getValue();
        }
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)requestUrl).build();
        this.resourceTypeName = (String)componentes.getPathSegments().get(0);
        if (componentes.getPathSegments().size() == 2 && componentes.getQueryParams().isEmpty()) {
            this.readById(connection, this.resourceTypeName, (String)componentes.getPathSegments().get(1));
        } else if (componentes.getPathSegments().size() == 4 && "_history".equals(componentes.getPathSegments().get(2)) && componentes.getQueryParams().isEmpty()) {
            this.readByIdAndVersion(connection, this.resourceTypeName, (String)componentes.getPathSegments().get(1), (String)componentes.getPathSegments().get(3));
        } else if (componentes.getPathSegments().size() == 1 && !componentes.getQueryParams().isEmpty()) {
            this.readByCondition(connection, this.resourceTypeName, this.parameterConverter.urlDecodeQueryParameters((Map<String, List<String>>)componentes.getQueryParams()));
        } else {
            throw new WebApplicationException(this.responseGenerator.badReadRequestUrl(this.index, requestUrl));
        }
    }

    private void readById(Connection connection, String resourceTypeName, String id) {
        Optional<ResourceDao<?>> optDao = this.daoProvider.getDao(resourceTypeName);
        if (optDao.isEmpty()) {
            this.responseResult = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        } else {
            ResourceDao<?> dao = optDao.get();
            Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, resourceTypeName, () -> dao.readWithTransaction(connection, this.parameterConverter.toUuid(resourceTypeName, id)));
            if (read.isEmpty()) {
                this.responseResult = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else {
                EntityTag resourceTag;
                Resource r = (Resource)read.get();
                Optional<Date> ifModifiedSince = Optional.ofNullable(this.entry.getRequest().getIfModifiedSince());
                Optional<Boolean> ifNoneMatch = Optional.ofNullable(this.entry.getRequest().getIfNoneMatch()).flatMap(this.parameterConverter::toEntityTag);
                if (ifNoneMatch.map(arg_0 -> ReadCommand.lambda$readById$1(resourceTag = new EntityTag(r.getMeta().getVersionId(), true), arg_0)).orElse(false).booleanValue() || ifModifiedSince.map(d -> r.getMeta().getLastUpdated().after((Date)d)).orElse(false).booleanValue()) {
                    this.responseResult = Response.notModified((EntityTag)resourceTag).lastModified(r.getMeta().getLastUpdated()).cacheControl(ResponseGenerator.PRIVATE_NO_CACHE_NO_TRANSFORM).build();
                } else {
                    this.singleResult = r;
                }
                this.authorizationHelper.checkReadAllowed(this.index, connection, this.identity, r);
            }
        }
    }

    private void readByIdAndVersion(Connection connection, String resourceTypeName, String id, String version) {
        Optional<ResourceDao<?>> optDao = this.daoProvider.getDao(resourceTypeName);
        Optional<Long> longVersion = this.parameterConverter.toVersion(version);
        if (optDao.isEmpty() || longVersion.isEmpty()) {
            this.responseResult = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        } else {
            ResourceDao<?> dao = optDao.get();
            Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, resourceTypeName, () -> dao.readVersionWithTransaction(connection, this.parameterConverter.toUuid(resourceTypeName, id), (Long)longVersion.get()));
            if (read.isEmpty()) {
                this.responseResult = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else {
                EntityTag resourceTag;
                Resource r = (Resource)read.get();
                Optional<Date> ifModifiedSince = Optional.ofNullable(this.entry.getRequest().getIfModifiedSince());
                Optional<Boolean> ifNoneMatch = Optional.ofNullable(this.entry.getRequest().getIfNoneMatch()).flatMap(this.parameterConverter::toEntityTag);
                if (ifNoneMatch.map(arg_0 -> ReadCommand.lambda$readByIdAndVersion$4(resourceTag = new EntityTag(r.getMeta().getVersionId(), true), arg_0)).orElse(false).booleanValue() || ifModifiedSince.map(d -> r.getMeta().getLastUpdated().after((Date)d)).orElse(false).booleanValue()) {
                    this.responseResult = Response.notModified((EntityTag)resourceTag).lastModified(r.getMeta().getLastUpdated()).cacheControl(ResponseGenerator.PRIVATE_NO_CACHE_NO_TRANSFORM).build();
                } else {
                    this.singleResult = r;
                }
                this.authorizationHelper.checkReadAllowed(this.index, connection, this.identity, r);
            }
        }
    }

    private void readByCondition(Connection connection, String resourceTypeName, Map<String, List<String>> cleanQueryParameters) {
        Optional<ResourceDao<?>> optDao = this.daoProvider.getDao(resourceTypeName);
        if (optDao.isEmpty()) {
            this.responseResult = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        } else {
            Integer page = this.parameterConverter.getFirstInt(cleanQueryParameters, "_page");
            int effectivePage = page == null ? 1 : page;
            Integer count = this.parameterConverter.getFirstInt(cleanQueryParameters, "_count");
            int effectiveCount = count == null || count < 0 ? this.defaultPageCount : count;
            SearchQuery<?> query = optDao.get().createSearchQuery(this.identity, effectivePage, effectiveCount);
            query.configureParameters(cleanQueryParameters);
            List<SearchQueryParameterError> errors = query.getUnsupportedQueryParameters();
            if (!errors.isEmpty() && PreferHandlingType.STRICT.equals((Object)this.handlingType)) {
                throw new WebApplicationException(this.responseGenerator.response(Response.Status.BAD_REQUEST, (Resource)this.responseGenerator.toOperationOutcomeError(errors), MediaType.APPLICATION_XML_TYPE).build());
            }
            PartialResult result = this.exceptionHandler.handleSqlException(() -> ((ResourceDao)optDao.get()).searchWithTransaction(connection, query));
            UriBuilder bundleUri = query.configureBundleUri(UriBuilder.fromPath((String)(this.serverBase + "/" + resourceTypeName)));
            this.multipleResult = this.responseGenerator.createSearchSet(result, errors, bundleUri, null, null, null);
            if (this.multipleResult != null && this.multipleResult.getEntry().size() == 1) {
                this.singleResult = ((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(0)).getResource();
                this.multipleResult = null;
                this.authorizationHelper.checkReadAllowed(this.index, connection, this.identity, this.singleResult);
            } else if (this.multipleResult != null && this.multipleResult.getEntry().size() == 2 && Bundle.SearchEntryMode.MATCH.equals((Object)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(0)).getSearch().getMode()) && Bundle.SearchEntryMode.OUTCOME.equals((Object)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(1)).getSearch().getMode())) {
                this.singleResult = ((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(0)).getResource();
                this.singleResultSearchWarning = (OperationOutcome)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(1)).getResource();
                this.multipleResult = null;
                this.authorizationHelper.checkReadAllowed(this.index, connection, this.identity, this.singleResult);
            } else if (this.multipleResult != null && this.multipleResult.getEntry().size() == 2 && Bundle.SearchEntryMode.MATCH.equals((Object)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(1)).getSearch().getMode()) && Bundle.SearchEntryMode.OUTCOME.equals((Object)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(0)).getSearch().getMode())) {
                this.singleResult = ((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(1)).getResource();
                this.singleResultSearchWarning = (OperationOutcome)((Bundle.BundleEntryComponent)this.multipleResult.getEntry().get(0)).getResource();
                this.multipleResult = null;
                this.authorizationHelper.checkReadAllowed(this.index, connection, this.identity, this.singleResult);
            } else {
                this.authorizationHelper.checkSearchAllowed(this.index, this.identity, resourceTypeName);
                this.authorizationHelper.filterIncludeResults(this.index, connection, this.identity, this.multipleResult);
                this.search = true;
            }
        }
    }

    @Override
    public Optional<Bundle.BundleEntryComponent> postExecute(Connection connection, EventHandler eventHandler) {
        if (this.singleResult != null) {
            this.referenceCleaner.cleanLiteralReferences(this.singleResult);
            Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
            resultEntry.setFullUrl(new IdType(this.serverBase, this.singleResult.getResourceType().name(), this.singleResult.getIdElement().getIdPart(), null).getValue());
            Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
            response.setStatus(Response.Status.OK.getStatusCode() + " " + Response.Status.OK.getReasonPhrase());
            response.setLocation(this.singleResult.getIdElement().withServerBase(this.serverBase, this.singleResult.getResourceType().name()).getValue());
            response.setEtag(RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)new EntityTag(this.singleResult.getMeta().getVersionId(), true)));
            response.setLastModified(this.singleResult.getMeta().getLastUpdated());
            this.setSingleResult(resultEntry, this.singleResult);
            if (this.singleResultSearchWarning != null) {
                response.setOutcome((Resource)this.singleResultSearchWarning);
            }
            return Optional.of(resultEntry);
        }
        if (this.multipleResult != null) {
            this.multipleResult.getEntry().stream().filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).forEach(arg_0 -> ((ReferenceCleaner)this.referenceCleaner).cleanLiteralReferences(arg_0));
            Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
            resultEntry.setFullUrl("urn:uuid:" + UUID.randomUUID().toString());
            Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
            response.setStatus(Response.Status.OK.getStatusCode() + " " + Response.Status.OK.getReasonPhrase());
            this.setMultipleResult(resultEntry, this.multipleResult);
            return Optional.of(resultEntry);
        }
        Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
        response.setStatus(this.responseResult.getStatusInfo().getStatusCode() + " " + this.responseResult.getStatusInfo().getReasonPhrase());
        if (this.responseResult.getEntityTag() != null) {
            response.setEtag(this.responseResult.getEntityTag().getValue());
        }
        if (this.responseResult.getLastModified() != null) {
            response.setLastModified(this.responseResult.getLastModified());
        }
        return Optional.of(resultEntry);
    }

    protected void setMultipleResult(Bundle.BundleEntryComponent resultEntry, Bundle multipleResult) {
        resultEntry.setResource((Resource)multipleResult);
    }

    protected void setSingleResult(Bundle.BundleEntryComponent resultEntry, Resource singleResult) {
        resultEntry.setResource(singleResult);
    }

    @Override
    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public boolean isSearch() {
        return this.search;
    }

    private static /* synthetic */ Boolean lambda$readByIdAndVersion$4(EntityTag resourceTag, EntityTag t) {
        return t.equals((Object)resourceTag);
    }

    private static /* synthetic */ Boolean lambda$readById$1(EntityTag resourceTag, EntityTag t) {
        return t.equals((Object)resourceTag);
    }
}

