/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractAuthorizationRule;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelper;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.TaskDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAuthorizationRule
extends AbstractAuthorizationRule<Task, TaskDao> {
    private static final Logger logger = LoggerFactory.getLogger(TaskAuthorizationRule.class);
    private static final String CODE_SYSTEM_BPMN_MESSAGE = "http://dsf.dev/fhir/CodeSystem/bpmn-message";
    private static final String CODE_SYSTEM_BPMN_MESSAGE_MESSAGE_NAME = "message-name";
    private static final String CODE_SYSTEM_BPMN_MESSAGE_BUSINESS_KEY = "business-key";
    private static final String INSTANTIATES_CANONICAL_PATTERN_STRING = "(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$";
    private static final Pattern INSTANTIATES_CANONICAL_PATTERN = Pattern.compile("(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
    private static final String NAMING_SYSTEM_TASK_IDENTIFIER = "http://dsf.dev/sid/task-identifier";
    private final ProcessAuthorizationHelper processAuthorizationHelper;

    public TaskAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter, ProcessAuthorizationHelper processAuthorizationHelper) {
        super(Task.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
        this.processAuthorizationHelper = processAuthorizationHelper;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.processAuthorizationHelper, "processAuthorizationHelper");
    }

    @Override
    public Optional<String> reasonCreateAllowed(Connection connection, Identity identity, Task newResource) {
        if (identity.hasDsfRole((DsfRole)FhirServerRole.CREATE)) {
            if (Task.TaskStatus.DRAFT.equals((Object)newResource.getStatus())) {
                if (identity.isLocalIdentity() && identity instanceof OrganizationIdentity) {
                    Optional<String> errors = this.draftTaskOk(connection, identity, newResource);
                    if (errors.isEmpty()) {
                        logger.info("Create of Task authorized for local organization identity '{}', Task.status draft", (Object)identity.getName());
                        return Optional.of("Local identity, Task.status draft");
                    }
                    logger.warn("Create of Task unauthorized for identity '{}', Task.status draft, {}", (Object)identity.getName(), (Object)errors.get());
                    return Optional.empty();
                }
                logger.warn("Create of Task unauthorized for identity '{}', Task.status draft, not allowed for non local organization identity", (Object)identity.getName());
                return Optional.empty();
            }
            if (Task.TaskStatus.REQUESTED.equals((Object)newResource.getStatus())) {
                Optional<String> errors = this.requestedTaskOk(connection, identity, newResource);
                if (errors.isEmpty()) {
                    if (this.taskAllowedForRequesterAndRecipient(connection, identity, newResource)) {
                        logger.info("Create of Task authorized for identity '{}', Task.status requested, process allowed for current identity", (Object)identity.getName());
                        return Optional.of("Local or remote identity, Task.status requested, Task.requester current identity's organization, Task.restriction.recipient local organization, process with instantiatesCanonical and message-name allowed for current identity, Task defines needed profile");
                    }
                    logger.warn("Create of Task unauthorized for identity '{}', Task.status requested, process with instantiatesCanonical, message-name, requester or recipient not allowed", (Object)identity.getName());
                    return Optional.empty();
                }
                logger.warn("Create of Task unauthorized for identity '{}', Task.status requested, {}", (Object)identity.getName(), (Object)errors.get());
                return Optional.empty();
            }
            logger.warn("Create of Task unauthorized for identity '{}', Task.status not {} and not {}", new Object[]{identity.getName(), Task.TaskStatus.DRAFT.toCode(), Task.TaskStatus.REQUESTED.toCode()});
            return Optional.empty();
        }
        logger.warn("Create of Task unauthorized for identity '{}', no role {}", (Object)identity.getName(), (Object)FhirServerRole.CREATE);
        return Optional.empty();
    }

    private Optional<String> requestedTaskOk(Connection connection, Identity identity, Task newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.getIdentifier().stream().anyMatch(i -> NAMING_SYSTEM_TASK_IDENTIFIER.equals(i.getSystem()))) {
            errors.add("Task.identifier[http://dsf.dev/sid/task-identifier] defined");
        }
        if (newResource.hasRequester()) {
            if (!this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "Task.requester", newResource.getRequester())) {
                errors.add("Task.requester current identity not part of referenced organization");
            }
        } else {
            errors.add("Task.requester missing");
        }
        if (newResource.hasRestriction()) {
            if (newResource.getRestriction().getRecipient().size() == 1) {
                ResourceReference reference = new ResourceReference("Task.restriction.recipient", newResource.getRestriction().getRecipientFirstRep(), new Class[]{Organization.class});
                Optional<Resource> recipient = this.referenceResolver.resolveReference(identity, reference, connection);
                if (recipient.isPresent()) {
                    if (recipient.get() instanceof Organization) {
                        if (!this.isLocalOrganization((Organization)recipient.get())) {
                            errors.add("Task.restriction.recipient not local organization");
                        }
                    } else {
                        errors.add("Task.restriction.recipient not a organization");
                    }
                } else {
                    errors.add("Task.restriction.recipient could not be resolved");
                }
            } else {
                errors.add("Task.restriction.recipient missing or more than one");
            }
        } else {
            errors.add("Task.restriction not defined");
        }
        if (newResource.hasInstantiatesCanonical()) {
            if (!INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical()).matches()) {
                errors.add("Task.instantiatesCanonical not matching (?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$ pattern");
            }
        } else {
            errors.add("Task.instantiatesCanonical not defined");
        }
        if (newResource.hasInput()) {
            if (this.getMessageNames(newResource).count() != 1L) {
                errors.add("Task.input with system http://dsf.dev/fhir/CodeSystem/bpmn-message and code message-name with non empty string value not defined or more than one");
            }
        } else {
            errors.add("Task.input empty");
        }
        if (newResource.hasOutput()) {
            errors.add("Task.output not empty");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private Optional<String> draftTaskOk(Connection connection, Identity identity, Task newResource) {
        ResourceReference reference;
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.getIdentifier().stream().noneMatch(i -> NAMING_SYSTEM_TASK_IDENTIFIER.equals(i.getSystem()))) {
            errors.add("Task.identifier[http://dsf.dev/sid/task-identifier] missing");
        }
        if (newResource.hasRequester()) {
            reference = new ResourceReference("Task.requester", newResource.getRequester(), new Class[]{Organization.class});
            Optional<Resource> requester = this.referenceResolver.resolveReference(identity, reference, connection);
            if (requester.isPresent()) {
                if (requester.get() instanceof Organization) {
                    if (!this.isLocalOrganization((Organization)requester.get())) {
                        errors.add("Task.requester not local organization");
                    }
                } else {
                    errors.add("Task.requester not a organization");
                }
            } else {
                errors.add("Task.requester could not be resolved");
            }
        } else {
            errors.add("Task.requester missing");
        }
        if (newResource.hasRestriction()) {
            if (newResource.getRestriction().getRecipient().size() == 1) {
                reference = new ResourceReference("Task.restriction.recipient", newResource.getRestriction().getRecipientFirstRep(), new Class[]{Organization.class});
                Optional<Resource> recipient = this.referenceResolver.resolveReference(identity, reference, connection);
                if (recipient.isPresent()) {
                    if (recipient.get() instanceof Organization) {
                        if (!this.isLocalOrganization((Organization)recipient.get())) {
                            errors.add("Task.restriction.recipient not local organization");
                        }
                    } else {
                        errors.add("Task.restriction.recipient not a organization");
                    }
                } else {
                    errors.add("Task.restriction.recipient could not be resolved");
                }
            } else {
                errors.add("Task.restriction.recipient missing or more than one");
            }
        } else {
            errors.add("Task.restriction not defined");
        }
        if (newResource.hasInstantiatesCanonical()) {
            if (!INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical()).matches()) {
                errors.add("Task.instantiatesCanonical not matching (?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$ pattern");
            }
        } else {
            errors.add("Task.instantiatesCanonical not defined");
        }
        if (newResource.hasInput()) {
            if (this.getMessageNames(newResource).count() != 1L) {
                errors.add("Task.input with system http://dsf.dev/fhir/CodeSystem/bpmn-message and code message-name with non empty string value not defined or more than one");
            }
        } else {
            errors.add("Task.input empty");
        }
        if (newResource.hasOutput()) {
            errors.add("Task.output not empty");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private Stream<String> getMessageNames(Task newResource) {
        return newResource.getInput().stream().filter(Task.ParameterComponent::hasType).filter(i -> i.getType().hasCoding()).filter(i -> i.getType().getCoding().stream().filter(Coding::hasSystem).filter(Coding::hasCode).anyMatch(c -> CODE_SYSTEM_BPMN_MESSAGE.equals(c.getSystem()) && CODE_SYSTEM_BPMN_MESSAGE_MESSAGE_NAME.equals(c.getCode()))).filter(Task.ParameterComponent::hasValue).filter(i -> i.getValue() instanceof StringType).map(Task.ParameterComponent::getValue).map(v -> (StringType)v).map(t -> t.getValueAsString()).filter(s -> !s.isBlank());
    }

    private boolean taskAllowedForRequesterAndRecipient(Connection connection, Identity requester, Task newResource) {
        Optional<Identity> recipientOpt = this.organizationProvider.getLocalOrganizationAsIdentity();
        if (recipientOpt.isEmpty()) {
            logger.warn("Local organization does not exist");
            return false;
        }
        Matcher matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical());
        if (matcher.matches()) {
            String processUrl = matcher.group("processUrl");
            String processVersion = matcher.group("processVersion");
            try {
                Optional<ActivityDefinition> activityDefinitionOpt = this.daoProvider.getActivityDefinitionDao().readByProcessUrlVersionAndStatusDraftOrActiveWithTransaction(connection, processUrl, processVersion);
                if (activityDefinitionOpt.isEmpty()) {
                    logger.warn("No ActivityDefinition with process-url '{}' and process-version '{}'", (Object)processUrl, (Object)processVersion);
                    return false;
                }
                ActivityDefinition activityDefinition = activityDefinitionOpt.get();
                Identity recipient = recipientOpt.get();
                List taskProfiles = newResource.getMeta().getProfile().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValueAsString).collect(Collectors.toList());
                String messageName = this.getMessageNames(newResource).findFirst().get();
                boolean okForRecipient = this.processAuthorizationHelper.getRecipients(activityDefinition, processUrl, processVersion, messageName, taskProfiles).anyMatch(r -> r.isRecipientAuthorized(recipient, this.getAffiliations(connection, this.organizationProvider.getLocalOrganizationIdentifierValue())));
                boolean okForRequester = this.processAuthorizationHelper.getRequesters(activityDefinition, processUrl, processVersion, messageName, taskProfiles).anyMatch(r -> r.isRequesterAuthorized(requester, this.getAffiliations(connection, requester.getOrganizationIdentifierValue().orElse(null))));
                if (!okForRecipient && !okForRequester) {
                    logger.warn("Task not allowed for requester and recipient");
                } else if (!okForRecipient) {
                    logger.warn("Task not allowed for recipient");
                } else if (!okForRequester) {
                    logger.warn("Task not allowed for requester");
                }
                return okForRecipient && okForRequester;
            }
            catch (SQLException e) {
                logger.warn("Error while reading ActivityDefinitions", (Throwable)e);
                return false;
            }
        }
        logger.warn("Task.instantiatesCanonical not matching {} pattern", (Object)INSTANTIATES_CANONICAL_PATTERN_STRING);
        return false;
    }

    private boolean taskAllowedForRecipient(Connection connection, Task newResource) {
        Optional<Identity> recipientOpt = this.organizationProvider.getLocalOrganizationAsIdentity();
        if (recipientOpt.isEmpty()) {
            logger.warn("Local organization does not exist");
            return false;
        }
        Matcher matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical());
        if (matcher.matches()) {
            String processUrl = matcher.group("processUrl");
            String processVersion = matcher.group("processVersion");
            try {
                Optional<ActivityDefinition> activityDefinitionOpt = this.daoProvider.getActivityDefinitionDao().readByProcessUrlVersionAndStatusDraftOrActiveWithTransaction(connection, processUrl, processVersion);
                if (activityDefinitionOpt.isEmpty()) {
                    logger.warn("No ActivityDefinition with process-url '{}' and process-version '{}'", (Object)processUrl, (Object)processVersion);
                    return false;
                }
                ActivityDefinition activityDefinition = activityDefinitionOpt.get();
                Identity recipient = recipientOpt.get();
                List taskProfiles = newResource.getMeta().getProfile().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValueAsString).collect(Collectors.toList());
                String messageName = this.getMessageNames(newResource).findFirst().get();
                boolean okForRecipient = this.processAuthorizationHelper.getRecipients(activityDefinition, processUrl, processVersion, messageName, taskProfiles).anyMatch(r -> r.isRecipientAuthorized(recipient, this.getAffiliations(connection, this.organizationProvider.getLocalOrganizationIdentifierValue())));
                if (!okForRecipient) {
                    logger.warn("Task not allowed for recipient");
                }
                return okForRecipient;
            }
            catch (SQLException e) {
                logger.warn("Error while reading ActivityDefinitions", (Throwable)e);
                return false;
            }
        }
        logger.warn("Task.instantiatesCanonical not matching {} pattern", (Object)INSTANTIATES_CANONICAL_PATTERN_STRING);
        return false;
    }

    @Override
    public Optional<String> reasonReadAllowed(Connection connection, Identity identity, Task existingResource) {
        String resourceId = this.parameterConverter.toUuid(this.getResourceTypeName(), existingResource.getIdElement().getIdPart()).toString();
        long resourceVersion = existingResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            if (this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "Task.requester", existingResource.getRequester())) {
                logger.info("Read of Task/{}/_history/{} authorized for identity '{}', Task.requester reference could be resolved and current identity part of referenced organization", new Object[]{resourceId, resourceVersion, identity.getName()});
                return Optional.of("Task.requester resolved and identity part of referenced organization");
            }
            if (identity.isLocalIdentity() && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "Task.restriction.recipient", existingResource.getRestriction().getRecipientFirstRep())) {
                logger.info("Read of Task/{}/_history/{} authorized for identity '{}', Task.restriction.recipient reference could be resolved and current identity part of referenced organization", new Object[]{resourceId, resourceVersion, identity.getName()});
                return Optional.of("Task.restriction.recipient resolved and local identity part of referenced organization");
            }
            logger.warn("Read of Task/{}/_history/{} unauthorized for identity '{}', Task.requester or Task.restriction.recipient references could not be resolved or current identity not part of referenced organizations", new Object[]{resourceId, resourceVersion, identity.getName()});
            return Optional.empty();
        }
        logger.warn("Read of Task/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{resourceId, resourceVersion, identity.getName(), FhirServerRole.READ});
        return Optional.empty();
    }

    @Override
    public Optional<String> reasonUpdateAllowed(Connection connection, Identity identity, Task oldResource, Task newResource) {
        String oldResourceId = this.parameterConverter.toUuid(this.getResourceTypeName(), oldResource.getIdElement().getIdPart()).toString();
        long oldResourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.UPDATE)) {
            if (identity.isLocalIdentity() && identity instanceof OrganizationIdentity) {
                if (Task.TaskStatus.DRAFT.equals((Object)oldResource.getStatus()) && Task.TaskStatus.DRAFT.equals((Object)newResource.getStatus())) {
                    Optional<String> errors = this.draftTaskOk(connection, identity, newResource);
                    if (errors.isEmpty()) {
                        logger.info("Update of Task/{}/_history/{} ({} -> {}) authorized for local identity '{}'", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.DRAFT.toCode(), Task.TaskStatus.DRAFT.toCode(), identity.getName()});
                        return Optional.of("Local identity, old Task.status draft, new Task.status draft");
                    }
                    logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for identity '{}', {}", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.DRAFT.toCode(), Task.TaskStatus.DRAFT.toCode(), identity.getName(), errors.get()});
                    return Optional.empty();
                }
                if (Task.TaskStatus.REQUESTED.equals((Object)oldResource.getStatus()) && Task.TaskStatus.INPROGRESS.equals((Object)newResource.getStatus())) {
                    Optional<String> same = this.reasonNotSame(oldResource, newResource);
                    if (same.isEmpty()) {
                        if (this.taskAllowedForRecipient(connection, newResource)) {
                            if (!newResource.hasOutput()) {
                                String businessKeyAdded = !this.hasBusinessKey(oldResource) && this.hasBusinessKey(newResource) ? " (business-key added)" : "";
                                logger.info("Update of Task/{}/_history/{} ({} -> {}) authorized for local identity '{}', old Task.status requested, new Task.status in-progress, process allowed for current identity", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.REQUESTED.toCode(), Task.TaskStatus.INPROGRESS.toCode(), identity.getName()});
                                return Optional.of("Local identity, Task.status in-progress, Task.restriction.recipient local organization, process with instantiatesCanonical and message-name allowed for current identity, Task defines needed profile, Task.instantiatesCanonical not modified, Task.requester not modified, Task.restriction not modified, Task.input not modified" + businessKeyAdded + ", Task has no output");
                            }
                            logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', Task.output not expected", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.REQUESTED.toCode(), Task.TaskStatus.INPROGRESS.toCode(), identity.getName()});
                            return Optional.empty();
                        }
                        logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', process with instantiatesCanonical, message-name, requester or recipient not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.REQUESTED.toCode(), Task.TaskStatus.INPROGRESS.toCode(), identity.getName()});
                        return Optional.empty();
                    }
                    logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', modification of Task properties {} not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.REQUESTED.toCode(), Task.TaskStatus.INPROGRESS.toCode(), identity.getName(), same.get()});
                    return Optional.empty();
                }
                if (Task.TaskStatus.INPROGRESS.equals((Object)oldResource.getStatus()) && Task.TaskStatus.COMPLETED.equals((Object)newResource.getStatus())) {
                    Optional<String> same = this.reasonNotSame(oldResource, newResource);
                    if (same.isEmpty()) {
                        if (this.taskAllowedForRecipient(connection, newResource)) {
                            logger.info("Update of Task/{}/_history/{} ({} -> {}) authorized for local identity '{}', old Task.status in-progress, new Task.status completed, process allowed for current identity", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.COMPLETED.toCode(), identity.getName()});
                            return Optional.of("Local identity, Task.status completed, Task.restriction.recipient local organization, process with instantiatesCanonical and message-name allowed for current identity, Task defines needed profile, Task.instantiatesCanonical not modified, Task.requester not modified, Task.restriction not modified, Task.input not modified");
                        }
                        logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', process with instantiatesCanonical, message-name, requester or recipient not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.COMPLETED.toCode(), identity.getName()});
                        return Optional.empty();
                    }
                    logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', modification of Task properties {} not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.COMPLETED.toCode(), identity.getName(), same.get()});
                    return Optional.empty();
                }
                if (Task.TaskStatus.INPROGRESS.equals((Object)oldResource.getStatus()) && Task.TaskStatus.FAILED.equals((Object)newResource.getStatus())) {
                    Optional<String> same = this.reasonNotSame(oldResource, newResource);
                    if (same.isEmpty()) {
                        if (this.taskAllowedForRecipient(connection, newResource)) {
                            logger.info("Update of Task/{}/_history/{} ({} -> {}) authorized for local identity '{}', old Task.status in-progress, new Task.status failed, process allowed for current identity", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.FAILED.toCode(), identity.getName()});
                            return Optional.of("Local identity, Task.status failed, Task.restriction.recipient local organization, process with instantiatesCanonical and message-name allowed for current identity, Task defines needed profile, Task.instantiatesCanonical not modified, Task.requester not modified, Task.restriction not modified, Task.input not modified");
                        }
                        logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', process with instantiatesCanonical, message-name, requester or recipient not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.FAILED.toCode(), identity.getName()});
                        return Optional.empty();
                    }
                    logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', modification of Task properties {} not allowed", new Object[]{oldResourceId, oldResourceVersion, Task.TaskStatus.INPROGRESS.toCode(), Task.TaskStatus.FAILED.toCode(), identity.getName(), same.get()});
                    return Optional.empty();
                }
                logger.warn("Update of Task/{}/_history/{} ({} -> {}) unauthorized for local identity '{}', old vs. new Task.status not one of {}", new Object[]{oldResourceId, oldResourceVersion, oldResource.getStatus() != null ? oldResource.getStatus().toCode() : null, newResource.getStatus() != null ? newResource.getStatus().toCode() : null, identity.getName(), Stream.of(Stream.of(Task.TaskStatus.DRAFT, Task.TaskStatus.DRAFT), Stream.of(Task.TaskStatus.REQUESTED, Task.TaskStatus.INPROGRESS), Stream.of(Task.TaskStatus.INPROGRESS, Task.TaskStatus.COMPLETED), Stream.of(Task.TaskStatus.INPROGRESS, Task.TaskStatus.FAILED)).map(s -> s.map(Task.TaskStatus::toCode).collect(Collectors.joining("->"))).collect(Collectors.joining(", ", "[", "]"))});
                return Optional.empty();
            }
            logger.warn("Update of Task/{}/_history/{} unauthorized for non local organization identity '{}'", new Object[]{oldResourceId, oldResourceVersion, identity.getName()});
            return Optional.empty();
        }
        logger.warn("Update of Task/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{this.getResourceTypeName(), oldResourceId, oldResourceVersion, identity.getName(), FhirServerRole.UPDATE});
        return Optional.empty();
    }

    private Optional<String> reasonNotSame(Task oldResource, Task newResource) {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (!oldResource.getRequester().equalsDeep((Base)newResource.getRequester())) {
            errors.add("Task.requester");
        }
        if (!oldResource.getRestriction().equalsDeep((Base)newResource.getRestriction())) {
            errors.add("Task.restriction");
        }
        if (!oldResource.getInstantiatesCanonical().equals(newResource.getInstantiatesCanonical())) {
            errors.add("Task.instantiatesCanonical");
        }
        List oldResourceInputs = oldResource.getInput();
        List<Task.ParameterComponent> newResourceInputs = newResource.getInput();
        if (Task.TaskStatus.REQUESTED.equals((Object)oldResource.getStatus()) && !this.hasBusinessKey(oldResource) && Task.TaskStatus.INPROGRESS.equals((Object)newResource.getStatus()) && this.hasBusinessKey(newResource)) {
            newResourceInputs = newResourceInputs.stream().filter(this.isBusinessKey().negate()).toList();
        }
        if (oldResourceInputs.size() != newResourceInputs.size()) {
            errors.add("Task.input");
        } else {
            for (int i = 0; i < oldResourceInputs.size(); ++i) {
                if (((Task.ParameterComponent)oldResourceInputs.get(i)).equalsDeep((Base)newResourceInputs.get(i))) continue;
                errors.add("Task.input[" + i + "]");
                break;
            }
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        logger.debug("Old Task: {}", (Object)FhirContext.forR4().newJsonParser().setStripVersionsFromReferences(Boolean.valueOf(false)).encodeResourceToString((IBaseResource)oldResource));
        logger.debug("New Task: {}", (Object)FhirContext.forR4().newJsonParser().setStripVersionsFromReferences(Boolean.valueOf(false)).encodeResourceToString((IBaseResource)newResource));
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private boolean hasBusinessKey(Task resource) {
        return resource.getInput().stream().anyMatch(this.isBusinessKey());
    }

    private Predicate<Task.ParameterComponent> isBusinessKey() {
        return i -> i.getType().getCoding().stream().anyMatch(c -> CODE_SYSTEM_BPMN_MESSAGE.equals(c.getSystem()) && CODE_SYSTEM_BPMN_MESSAGE_BUSINESS_KEY.equals(c.getCode()));
    }

    @Override
    public Optional<String> reasonDeleteAllowed(Connection connection, Identity identity, Task oldResource) {
        String oldResourceId = this.parameterConverter.toUuid(this.getResourceTypeName(), oldResource.getIdElement().getIdPart()).toString();
        long oldResourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.DELETE)) {
            if (identity.isLocalIdentity() && identity instanceof OrganizationIdentity) {
                if (Task.TaskStatus.DRAFT.equals((Object)oldResource.getStatus())) {
                    logger.info("Delete of Task/{}/_history/{} authorized for local identity '{}', Task.status draft", new Object[]{oldResourceId, oldResourceVersion, identity.getName()});
                    return Optional.of("Local identity, Task.status draft");
                }
                logger.warn("Delete of Task/{}/_history/{} unauthorized for local identity '{}', Task.status not draft", new Object[]{oldResourceId, oldResourceVersion, identity.getName()});
                return Optional.empty();
            }
            logger.warn("Delete of Task/{}/_history/{} unauthorized for non local organization identity '{}'", new Object[]{oldResourceId, oldResourceVersion, identity.getName()});
            return Optional.empty();
        }
        logger.warn("Delete of Task/{}/_history/{} unauthorized for identity '{}', no role {}", (Object)identity.getName(), (Object)FhirServerRole.DELETE);
        return Optional.empty();
    }
}

