/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.BundleDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;

public class BundleAuthorizationRule
extends AbstractMetaTagAuthorizationRule<Bundle, BundleDao> {
    public BundleAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(Bundle.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, Bundle newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, Bundle newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Identity identity, Bundle newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("Bundle is missing valid read access tag");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean resourceExists(Connection connection, Bundle newResource) {
        return false;
    }

    @Override
    protected boolean modificationsOk(Connection connection, Bundle oldResource, Bundle newResource) {
        return true;
    }
}

