/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Resource;

public class AuthorizationRuleProviderImpl
implements AuthorizationRuleProvider {
    private final Map<Class<? extends Resource>, AuthorizationRule<?>> authorizationRulesByResourecClass;
    private final Map<String, AuthorizationRule<?>> authorizationRulesByResourceTypeName = new HashMap();

    public AuthorizationRuleProviderImpl(AuthorizationRule<?> ... rules) {
        this.authorizationRulesByResourecClass = Arrays.stream(rules).collect(Collectors.toMap(AuthorizationRule::getResourceType, Function.identity()));
        this.authorizationRulesByResourecClass.forEach((k, v) -> this.authorizationRulesByResourceTypeName.put(k.getAnnotation(ResourceDef.class).name(), (AuthorizationRule<?>)v));
    }

    @Override
    public Optional<AuthorizationRule<?>> getAuthorizationRule(Class<?> resourceClass) {
        AuthorizationRule<?> authorizationRule = this.authorizationRulesByResourecClass.get(resourceClass);
        return Optional.ofNullable(authorizationRule);
    }

    @Override
    public Optional<AuthorizationRule<?>> getAuthorizationRule(String resourceTypeName) {
        AuthorizationRule<?> authorizationRule = this.authorizationRulesByResourceTypeName.get(resourceTypeName);
        return Optional.ofNullable(authorizationRule);
    }
}

