/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import dev.dsf.common.auth.conf.DsfRole;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;

public enum FhirServerRole implements DsfRole
{
    CREATE,
    READ,
    UPDATE,
    DELETE,
    SEARCH,
    HISTORY,
    PERMANENT_DELETE,
    WEBSOCKET;

    public static final Set<FhirServerRole> LOCAL_ORGANIZATION;
    public static final Set<FhirServerRole> REMOTE_ORGANIZATION;

    public static boolean isValid(String role) {
        return role != null && !role.isBlank() && Stream.of(FhirServerRole.values()).map(Enum::name).anyMatch(n -> n.equals(role));
    }

    static {
        LOCAL_ORGANIZATION = EnumSet.of(CREATE, new FhirServerRole[]{READ, UPDATE, DELETE, SEARCH, HISTORY, PERMANENT_DELETE, WEBSOCKET});
        REMOTE_ORGANIZATION = EnumSet.of(CREATE, new FhirServerRole[]{READ, UPDATE, DELETE, SEARCH, HISTORY});
    }
}

