/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.jaxrs;

import dev.dsf.fhir.webservice.jaxrs.AbstractServiceJaxrs;
import dev.dsf.fhir.webservice.specification.BasicResourceService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractResourceServiceJaxrs<R extends Resource, S extends BasicResourceService<R>>
extends AbstractServiceJaxrs<S>
implements BasicResourceService<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceServiceJaxrs.class);

    public AbstractResourceServiceJaxrs(S delegate) {
        super(delegate);
    }

    @Override
    @POST
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response create(R resource, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("POST {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).create(resource, uri, headers);
    }

    @Override
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response read(@PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).read(id, uri, headers);
    }

    @Override
    @GET
    @Path(value="/{id}/_history/{version}")
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response vread(@PathParam(value="id") String id, @PathParam(value="version") long version, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).vread(id, version, uri, headers);
    }

    @Override
    @GET
    @Path(value="/_history")
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response history(@Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).history(uri, headers);
    }

    @Override
    @GET
    @Path(value="/{id}/_history")
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response history(@PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).history(id, uri, headers);
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response update(@PathParam(value="id") String id, R resource, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("PUT {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).update(id, resource, uri, headers);
    }

    @Override
    @PUT
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response update(R resource, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("PUT {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).update(resource, uri, headers);
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response delete(@PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("DELETE {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).delete(id, uri, headers);
    }

    @Override
    @DELETE
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response delete(@Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("DELETE {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).delete(uri, headers);
    }

    @Override
    @GET
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response search(@Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).search(uri, headers);
    }

    @Override
    @POST
    @Path(value="/{validate : [$]validate(/)?}")
    @Consumes(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response postValidateNew(@PathParam(value="validate") String validate, Parameters parameters, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("POST {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).postValidateNew(validate, parameters, uri, headers);
    }

    @Override
    @GET
    @Path(value="/{validate : [$]validate(/)?}")
    @Consumes(value={"application/json+fhir", "application/fhir+json", "application/json", "application/xml+fhir", "application/fhir+xml", "application/xml"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response getValidateNew(@PathParam(value="validate") String validate, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).getValidateNew(validate, uri, headers);
    }

    @Override
    @POST
    @Path(value="/{id}/{validate : [$]validate(/)?}")
    @Consumes(value={"application/json+fhir", "application/fhir+json", "application/json", "application/xml+fhir", "application/fhir+xml", "application/xml"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response postValidateExisting(@PathParam(value="validate") String validatePath, @PathParam(value="id") String id, Parameters parameters, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("POST {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).postValidateExisting(validatePath, id, parameters, uri, headers);
    }

    @Override
    @GET
    @Path(value="/{id}/{validate : [$]validate(/)?}")
    @Consumes(value={"application/json+fhir", "application/fhir+json", "application/json", "application/xml+fhir", "application/fhir+xml", "application/xml"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response getValidateExisting(@PathParam(value="validate") String validatePath, @PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).getValidateExisting(validatePath, id, uri, headers);
    }

    @Override
    @POST
    @Path(value="/{id}/{delete : [$]permanent-delete(/)?}")
    @Consumes(value={"application/json+fhir", "application/fhir+json", "application/json", "application/xml+fhir", "application/fhir+xml", "application/xml"})
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response deletePermanently(@PathParam(value="delete") String deletePath, @PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        logger.trace("POST {}", (Object)uri.getRequestUri().toString());
        return ((BasicResourceService)this.delegate).deletePermanently(deletePath, id, uri, headers);
    }
}

