/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.common.config.ProxyConfig;
import dev.dsf.common.config.ProxyConfigImpl;
import dev.dsf.common.documentation.Documentation;
import dev.dsf.tools.docker.secrets.DockerSecretsPropertySourceFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@org.springframework.context.annotation.PropertySource(value={"file:conf/config.properties"}, encoding="UTF-8", ignoreResourceNotFound=true)
public class PropertiesConfig {
    @Documentation(required=true, description="The address of the database used for the DSF FHIR server", recommendation="Change only if you don't use the provided docker-compose from the installation guide or made changes to the database settings/networking in the docker-compose", example="jdbc:postgresql://db/fhir")
    @Value(value="${dev.dsf.fhir.db.url}")
    private String dbUrl;
    @Documentation(description="The user name to access the database from the DSF FHIR server")
    @Value(value="${dev.dsf.fhir.db.user.username:fhir_server_user}")
    private String dbUsername;
    @Documentation(required=true, description="The password to access the database from the DSF FHIR server", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/db_user.password")
    @Value(value="${dev.dsf.fhir.db.user.password}")
    private char[] dbPassword;
    @Documentation(description="The user name to access the database from the DSF FHIR server for permanent deletes", recommendation="Use a different user then *DEV_DSF_FHIR_DB_USER_USERNAME*")
    @Value(value="${dev.dsf.fhir.db.user.permanent.delete.username:fhir_server_permanent_delete_user}")
    private String dbPermanentDeleteUsername;
    @Documentation(required=true, description="The password to access the database from the DSF FHIR server for permanent deletes", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/db_user_permanent_delete.password")
    @Value(value="${dev.dsf.fhir.db.user.permanent.delete.password}")
    private char[] dbPermanentDeletePassword;
    @Documentation(required=true, description="The base address of this DSF FHIR server to read/store fhir resources", example="https://foo.bar/fhir")
    @Value(value="${dev.dsf.fhir.server.base.url}")
    private String serverBaseUrl;
    @Documentation(description="The page size returned by the DSF FHIR server when reading/searching fhir resources")
    @Value(value="${dev.dsf.fhir.server.page.count:20}")
    private int defaultPageCount;
    @Documentation(required=true, description="Role config YAML")
    @Value(value="${dev.dsf.fhir.server.roleConfig}")
    private String roleConfig;
    @Documentation(required=true, description="The local identifier value used in the Allow-List", recommendation="By convention: The shortest possible FQDN that resolve the homepage of the organization", example="hospital.com")
    @Value(value="${dev.dsf.fhir.server.organization.identifier.value}")
    private String organizationIdentifierValue;
    @Documentation(description="The fhir bundle containing the initial Allow-List, loaded on startup of the DSF FHIR server", recommendation="Change only if you don't use the provided files from the installation guide, have local changes in the Allow-List or received an Allow-List from another source")
    @Value(value="${dev.dsf.fhir.server.init.bundle:conf/bundle.xml}")
    private String initBundleFile;
    @Documentation(required=true, description="PEM encoded file with one or more trusted root certificates to validate server certificates for https connections to remote DSF FHIR servers", recommendation="Use docker secret file to configure", example="/run/secrets/app_server_trust_certificates.pem")
    @Value(value="${dev.dsf.fhir.client.trust.server.certificate.cas}")
    private String webserviceClientCertificateTrustCertificatesFile;
    @Documentation(required=true, description="PEM encoded file with local client certificate for https connections to remote DSF FHIR servers", recommendation="Use docker secret file to configure", example="/run/secrets/app_client_certificate.pem")
    @Value(value="${dev.dsf.fhir.client.certificate}")
    private String webserviceClientCertificateFile;
    @Documentation(required=true, description="Private key corresponding to the local client certificate as PEM encoded file. Use *${env_variable}_PASSWORD* or *${env_variable}_PASSWORD_FILE* if private key is encrypted", recommendation="Use docker secret file to configure", example="/run/secrets/app_client_certificate_private_key.pem")
    @Value(value="${dev.dsf.fhir.client.certificate.private.key}")
    private String webserviceClientCertificatePrivateKeyFile;
    @Documentation(description="Password to decrypt the local client certificate encrypted private key", recommendation="Use docker secret file to configure using *${env_variable}_FILE*", example="/run/secrets/app_client_certificate_private_key.pem.password")
    @Value(value="${dev.dsf.fhir.client.certificate.private.key.password:#{null}}")
    private char[] webserviceClientCertificatePrivateKeyFilePassword;
    @Documentation(description="The timeout in milliseconds until a reading a resource from a remote DSF FHIR server is aborted", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.fhir.client.timeout.read:10000}")
    private int webserviceClientReadTimeout;
    @Documentation(description="The timeout in milliseconds until a connection is established between this DSF FHIR server and a remote DSF FHIR server", recommendation="Change default value only if timeout exceptions occur")
    @Value(value="${dev.dsf.fhir.client.timeout.connect:2000}")
    private int webserviceClientConnectTimeout;
    @Documentation(description="To enable verbose logging of requests to and replies from remote DSF FHIR servers, set to `true`")
    @Value(value="${dev.dsf.fhir.client.verbose:false}")
    private boolean webserviceClientVerbose;
    @Documentation(description="To disable static resource caching, set to `false`", recommendation="Only set to `false` for development")
    @Value(value="${dev.dsf.fhir.server.static.resource.cache:true}")
    private boolean staticResourceCacheEnabled;
    @Value(value="${dev.dsf.server.status.port}")
    private int jettyStatusConnectorPort;
    @Documentation(description="Forward (http/https) proxy url, use *DEV_DSF_BPE_PROXY_NOPROXY* to list domains that do not require a forward proxy", example="http://proxy.foo:8080")
    @Value(value="${dev.dsf.proxy.url:#{null}}")
    private String proxyUrl;
    @Documentation(description="Forward proxy username", recommendation="Configure username if proxy requires authentication")
    @Value(value="${dev.dsf.proxy.username:#{null}}")
    private String proxyUsername;
    @Documentation(description="Forward Proxy password", recommendation="Configure password if proxy requires authentication, use docker secret file to configure using *${env_variable}_FILE*")
    @Value(value="${dev.dsf.proxy.password:#{null}}")
    private char[] proxyPassword;
    @Documentation(description="Forward proxy no-proxy list, entries will match exactly or agianst (one level) sub-domains, if no port is specified - all ports are matched; comma or space separated list, YAML block scalars supported", example="foo.bar, test.com:8080")
    @Value(value="#{'${dev.dsf.proxy.noProxy:}'.trim().split('(,[ ]?)|(\\\\n)')}")
    private List<String> proxyNoProxy;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment environment) {
        new DockerSecretsPropertySourceFactory(environment).readDockerSecretsAndAddPropertiesToEnvironment();
        PropertiesConfig.injectEndpointProperties(environment);
        return new PropertySourcesPlaceholderConfigurer();
    }

    private static void injectEndpointProperties(ConfigurableEnvironment environment) {
        try {
            URL baseUrl = new URL(environment.getRequiredProperty("dev.dsf.fhir.server.base.url"));
            if (baseUrl.getHost() == null || baseUrl.getHost().isBlank()) {
                throw new IllegalStateException("No hostname defined in FHIR server base url");
            }
            Properties properties = new Properties();
            properties.put("dev.dsf.fhir.server.endpoint.address", baseUrl.toString());
            properties.put("dev.dsf.fhir.server.endpoint.identifier.value", baseUrl.getHost());
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("enpoint-properties", properties));
        }
        catch (IllegalStateException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public char[] getDbPassword() {
        return this.dbPassword;
    }

    public String getDbPermanentDeleteUsername() {
        return this.dbPermanentDeleteUsername;
    }

    public char[] getDbPermanentDeletePassword() {
        return this.dbPermanentDeletePassword;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public int getDefaultPageCount() {
        return this.defaultPageCount;
    }

    public String getRoleConfig() {
        return this.roleConfig;
    }

    public String getOrganizationIdentifierValue() {
        return this.organizationIdentifierValue;
    }

    public String getInitBundleFile() {
        return this.initBundleFile;
    }

    public String getWebserviceClientCertificateTrustCertificatesFile() {
        return this.webserviceClientCertificateTrustCertificatesFile;
    }

    public String getWebserviceClientCertificateFile() {
        return this.webserviceClientCertificateFile;
    }

    public String getWebserviceClientCertificatePrivateKeyFile() {
        return this.webserviceClientCertificatePrivateKeyFile;
    }

    public char[] getWebserviceClientCertificatePrivateKeyFilePassword() {
        return this.webserviceClientCertificatePrivateKeyFilePassword;
    }

    public int getWebserviceClientReadTimeout() {
        return this.webserviceClientReadTimeout;
    }

    public int getWebserviceClientConnectTimeout() {
        return this.webserviceClientConnectTimeout;
    }

    public boolean getWebserviceClientVerbose() {
        return this.webserviceClientVerbose;
    }

    public boolean getStaticResourceCacheEnabled() {
        return this.staticResourceCacheEnabled;
    }

    public int getJettyStatusConnectorPort() {
        return this.jettyStatusConnectorPort;
    }

    @Bean
    public ProxyConfig proxyConfig() {
        return new ProxyConfigImpl(this.proxyUrl, this.proxyUsername, this.proxyPassword, this.proxyNoProxy);
    }
}

