/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.history.HistoryService;
import dev.dsf.fhir.history.HistoryServiceImpl;
import dev.dsf.fhir.history.filter.HistoryIdentityFilterFactory;
import dev.dsf.fhir.history.filter.HistoryIdentityFilterFactoryImpl;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import dev.dsf.fhir.spring.config.ReferenceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HistoryConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private ReferenceConfig referenceConfig;
    @Autowired
    private DaoConfig daoConfig;

    @Bean
    public HistoryIdentityFilterFactory historyUserFilterFactory() {
        return new HistoryIdentityFilterFactoryImpl();
    }

    @Bean
    public HistoryService historyService() {
        return new HistoryServiceImpl(this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.getDefaultPageCount(), this.helperConfig.parameterConverter(), this.helperConfig.exceptionHandler(), this.helperConfig.responseGenerator(), this.referenceConfig.referenceCleaner(), this.daoConfig.historyDao(), this.historyUserFilterFactory());
    }
}

