/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.rev.include;

import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameterFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractRevIncludeParameterFactory
implements SearchQueryRevIncludeParameterFactory {
    private final List<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>();
    private final String resourceTypeName;
    private final String parameterName;
    private final List<String> targetResourceTypeNames;
    private List<IncludeParts> includeParts;

    public AbstractRevIncludeParameterFactory(String resourceTypeName, String parameterName, String ... targetResourceTypeName) {
        this.resourceTypeName = resourceTypeName;
        this.parameterName = parameterName;
        this.targetResourceTypeNames = Arrays.asList(targetResourceTypeName);
    }

    @Override
    public void configure(List<String> revIncludeParameters) {
        this.includeParts = this.getRevIncludeParts(revIncludeParameters);
    }

    private List<IncludeParts> getRevIncludeParts(List<String> revIncludeParameterValues) {
        List<IncludeParts> includeParts = revIncludeParameterValues.stream().map(IncludeParts::fromString).filter(p -> this.resourceTypeName.equals(p.getSourceResourceTypeName()) && this.parameterName.equals(p.getSearchParameterName()) && (this.targetResourceTypeNames.size() == 1 && p.getTargetResourceTypeName() == null || this.targetResourceTypeNames.contains(p.getTargetResourceTypeName()))).collect(Collectors.toList());
        return includeParts;
    }

    protected final void addError(SearchQueryParameterError error) {
        this.errors.add(error);
    }

    @Override
    public List<SearchQueryParameterError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected abstract String getRevIncludeSql(IncludeParts var1);

    protected abstract void modifyIncludeResource(Resource var1, Connection var2);

    @Override
    public List<SearchQueryIncludeParameter> getRevIncludeParameters() {
        return this.includeParts.stream().map(ip -> new SearchQueryIncludeParameter(this.getRevIncludeSql((IncludeParts)ip), (IncludeParts)ip, this::modifyIncludeResource)).collect(Collectors.toList());
    }
}

