/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractTokenParameter<R extends Resource>
extends AbstractSearchParameter<R> {
    protected TokenValueAndSearchType valueAndType;

    public AbstractTokenParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected Stream<String> getModifiedParameterNames() {
        return Stream.of(this.parameterName + ":not");
    }

    @Override
    protected void configureSearchParameter(Map<String, List<String>> queryParameters) {
        this.valueAndType = TokenValueAndSearchType.fromParamValue(this.parameterName, queryParameters, this::addError).orElse(null);
        if ((queryParameters.get(this.parameterName) != null || queryParameters.get(this.parameterName + ":not") != null) && queryParameters.getOrDefault(this.parameterName, Collections.emptyList()).size() + queryParameters.getOrDefault(this.parameterName + ":not", Collections.emptyList()).size() > 1) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, queryParameters.get(this.parameterName)));
        }
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        switch (this.valueAndType.type) {
            case CODE: {
                bundleUri.replaceQueryParam((String)(this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName), new Object[]{this.valueAndType.codeValue});
                break;
            }
            case CODE_AND_SYSTEM: {
                bundleUri.replaceQueryParam((String)(this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName), new Object[]{this.valueAndType.systemValue + "|" + this.valueAndType.codeValue});
                break;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                bundleUri.replaceQueryParam((String)(this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName), new Object[]{"|" + this.valueAndType.codeValue});
                break;
            }
            case SYSTEM: {
                bundleUri.replaceQueryParam((String)(this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName), new Object[]{this.valueAndType.systemValue + "|"});
            }
        }
    }

    protected boolean codingMatches(List<CodeableConcept> codes) {
        return codes.stream().flatMap(c -> c.getCoding().stream()).anyMatch(c -> this.valueAndType.negated ? !AbstractTokenParameter.codingMatches(this.valueAndType, c) : AbstractTokenParameter.codingMatches(this.valueAndType, c));
    }

    public static boolean codingMatches(TokenValueAndSearchType valueAndType, Coding coding) {
        switch (valueAndType.type) {
            case CODE: {
                return Objects.equals(valueAndType.codeValue, coding.getCode());
            }
            case CODE_AND_SYSTEM: {
                return Objects.equals(valueAndType.codeValue, coding.getCode()) && Objects.equals(valueAndType.systemValue, coding.getSystem());
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                return Objects.equals(valueAndType.codeValue, coding.getCode()) && (coding.getSystem() == null || coding.getSystem().isBlank());
            }
            case SYSTEM: {
                return Objects.equals(valueAndType.systemValue, coding.getSystem());
            }
        }
        return false;
    }
}

