/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import jakarta.ws.rs.core.UriBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractStringParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    protected StringValueAndSearchType valueAndType;

    public AbstractStringParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected Stream<String> getModifiedParameterNames() {
        return Stream.of(this.getParameterName() + StringSearchType.EXACT.modifier, this.getParameterName() + StringSearchType.CONTAINS.modifier);
    }

    @Override
    protected final void configureSearchParameter(Map<String, List<String>> queryParameters) {
        String startsWith;
        ArrayList<String> allValues = new ArrayList<String>();
        allValues.addAll(queryParameters.getOrDefault(this.parameterName + StringSearchType.STARTS_WITH.modifier, Collections.emptyList()));
        allValues.addAll(queryParameters.getOrDefault(this.parameterName + StringSearchType.EXACT.modifier, Collections.emptyList()));
        allValues.addAll(queryParameters.getOrDefault(this.parameterName + StringSearchType.CONTAINS.modifier, Collections.emptyList()));
        if (allValues.size() > 1) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, allValues));
        }
        if ((startsWith = AbstractStringParameter.getFirst(queryParameters, this.parameterName + StringSearchType.STARTS_WITH.modifier)) != null) {
            this.valueAndType = new StringValueAndSearchType(startsWith, StringSearchType.STARTS_WITH);
            return;
        }
        String exact = AbstractStringParameter.getFirst(queryParameters, this.parameterName + StringSearchType.EXACT.modifier);
        if (exact != null) {
            this.valueAndType = new StringValueAndSearchType(exact, StringSearchType.EXACT);
            return;
        }
        String contains = AbstractStringParameter.getFirst(queryParameters, this.parameterName + StringSearchType.CONTAINS.modifier);
        if (contains != null) {
            this.valueAndType = new StringValueAndSearchType(contains, StringSearchType.CONTAINS);
            return;
        }
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        bundleUri.replaceQueryParam(this.parameterName + this.valueAndType.type.modifier, new Object[]{this.valueAndType.value});
    }

    public static enum StringSearchType {
        STARTS_WITH(""),
        EXACT(":exact"),
        CONTAINS(":contains");

        public final String modifier;

        private StringSearchType(String modifier) {
            this.modifier = modifier;
        }
    }

    protected static class StringValueAndSearchType {
        public final String value;
        public final StringSearchType type;

        private StringValueAndSearchType(String value, StringSearchType type) {
            this.value = value;
            this.type = type;
        }
    }
}

