/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.SearchQuerySortParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractSearchParameter<R extends Resource>
implements SearchQueryParameter<R> {
    protected final String parameterName;
    private SearchQuerySortParameter sortParameter;
    private final List<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>();

    public AbstractSearchParameter(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public final String getParameterName() {
        return this.parameterName;
    }

    @Override
    public Stream<String> getBaseAndModifiedParameterNames() {
        return Stream.concat(Stream.of(this.getParameterName()), this.getModifiedParameterNames());
    }

    protected Stream<String> getModifiedParameterNames() {
        return Stream.empty();
    }

    protected IllegalStateException notDefined() {
        return new IllegalStateException("not defined");
    }

    @Override
    public final void configure(Map<String, List<String>> queryParameters) {
        SearchQuerySortParameter.SortDirection sortDirection = this.getSortDirection(AbstractSearchParameter.getFirst(queryParameters, "_sort"));
        if (sortDirection != null) {
            this.sortParameter = new SearchQuerySortParameter(this.getSortSql(sortDirection.getSqlModifierWithSpacePrefix()), this.parameterName, sortDirection);
        }
        this.configureIncludeParameter(queryParameters);
        this.configureSearchParameter(queryParameters);
    }

    @Override
    public List<SearchQueryParameterError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected final void addError(SearchQueryParameterError error) {
        this.errors.add(error);
    }

    protected static String getFirst(Map<String, List<String>> queryParameters, String key) {
        if (queryParameters.containsKey(key) && !queryParameters.get(key).isEmpty()) {
            return queryParameters.get(key).get(0);
        }
        return null;
    }

    private SearchQuerySortParameter.SortDirection getSortDirection(String sortParameters) {
        if (sortParameters == null || sortParameters.isBlank()) {
            return null;
        }
        Optional<String> sortParameter = Arrays.stream(sortParameters.split(",")).filter(s -> s.equals(this.parameterName) || s.equals("+" + this.parameterName) || s.equals("-" + this.parameterName)).findFirst();
        return sortParameter.map(SearchQuerySortParameter.SortDirection::fromString).orElse(null);
    }

    protected void configureIncludeParameter(Map<String, List<String>> queryParameters) {
    }

    protected abstract void configureSearchParameter(Map<String, List<String>> var1);

    @Override
    public Optional<SearchQuerySortParameter> getSortParameter() {
        return Optional.ofNullable(this.sortParameter);
    }

    protected abstract String getSortSql(String var1);

    @Override
    public List<SearchQueryIncludeParameter> getIncludeParameters() {
        return Collections.emptyList();
    }
}

