/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractReferenceParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    private static final String PARAMETER_NAME_IDENTIFIER_MODIFIER = ":identifier";
    private final Class<R> resourceType;
    private final String resourceTypeName;
    private final List<String> targetResourceTypeNames;
    private final List<SearchQueryIncludeParameter> includeParameters = new ArrayList<SearchQueryIncludeParameter>();
    protected ReferenceValueAndSearchType valueAndType;

    public AbstractReferenceParameter(Class<R> resourceType, String resourceTypeName, String parameterName, String ... targetResourceTypeNames) {
        super(parameterName);
        this.resourceType = resourceType;
        this.resourceTypeName = resourceTypeName;
        this.targetResourceTypeNames = Arrays.asList(targetResourceTypeNames);
    }

    @Override
    protected Stream<String> getModifiedParameterNames() {
        return Stream.of(this.getParameterName() + PARAMETER_NAME_IDENTIFIER_MODIFIER);
    }

    @Override
    protected void configureSearchParameter(Map<String, List<String>> queryParameters) {
        this.valueAndType = ReferenceValueAndSearchType.fromParamValue(this.targetResourceTypeNames, this.parameterName, queryParameters, this::addError).orElse(null);
    }

    @Override
    protected void configureIncludeParameter(Map<String, List<String>> queryParameters) {
        List<IncludeParts> includeParts = this.getIncludeParts(queryParameters);
        for (IncludeParts ip : includeParts) {
            String includeSql = this.getIncludeSql(ip);
            if (includeSql == null) continue;
            this.includeParameters.add(new SearchQueryIncludeParameter(includeSql, ip, (resource, connection) -> this.modifyIncludeResource(ip, (Resource)resource, (Connection)connection)));
        }
    }

    private List<IncludeParts> getIncludeParts(Map<String, List<String>> queryParameters) {
        List includeParameterValues = queryParameters.getOrDefault("_include", Collections.emptyList());
        List<IncludeParts> includeParts = includeParameterValues.stream().map(IncludeParts::fromString).filter(p -> this.resourceTypeName.equals(p.getSourceResourceTypeName()) && this.parameterName.equals(p.getSearchParameterName()) && (this.targetResourceTypeNames.size() == 1 && p.getTargetResourceTypeName() == null || this.targetResourceTypeNames.contains(p.getTargetResourceTypeName()))).collect(Collectors.toList());
        return includeParts;
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        block0 : switch (this.valueAndType.type) {
            case ID: {
                bundleUri.replaceQueryParam(this.parameterName, new Object[]{this.valueAndType.id});
                break;
            }
            case URL: {
                bundleUri.replaceQueryParam(this.parameterName, new Object[]{this.valueAndType.url});
                break;
            }
            case RESOURCE_NAME_AND_ID: {
                bundleUri.replaceQueryParam(this.parameterName, new Object[]{this.valueAndType.resourceName + "/" + this.valueAndType.id});
                break;
            }
            case TYPE_AND_ID: {
                bundleUri.replaceQueryParam(this.parameterName + ":" + this.valueAndType.resourceName, new Object[]{this.valueAndType.id});
                break;
            }
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                bundleUri.replaceQueryParam(this.parameterName + ":" + this.valueAndType.resourceName, new Object[]{this.valueAndType.resourceName + "/" + this.valueAndType.id});
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        bundleUri.replaceQueryParam(this.parameterName + PARAMETER_NAME_IDENTIFIER_MODIFIER, new Object[]{this.valueAndType.identifier.codeValue});
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        bundleUri.replaceQueryParam(this.parameterName + PARAMETER_NAME_IDENTIFIER_MODIFIER, new Object[]{this.valueAndType.identifier.systemValue + "|" + this.valueAndType.identifier.codeValue});
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        bundleUri.replaceQueryParam(this.parameterName + PARAMETER_NAME_IDENTIFIER_MODIFIER, new Object[]{"|" + this.valueAndType.identifier.codeValue});
                        break block0;
                    }
                    case SYSTEM: {
                        bundleUri.replaceQueryParam(this.parameterName + PARAMETER_NAME_IDENTIFIER_MODIFIER, new Object[]{this.valueAndType.identifier.systemValue + "|"});
                    }
                }
            }
        }
    }

    @Override
    public List<SearchQueryIncludeParameter> getIncludeParameters() {
        return Collections.unmodifiableList(this.includeParameters);
    }

    protected abstract String getIncludeSql(IncludeParts var1);

    @Override
    public void resolveReferencesForMatching(Resource resource, DaoProvider daoProvider) throws SQLException {
        if (this.resourceType.isInstance(resource)) {
            this.doResolveReferencesForMatching((DomainResource)this.resourceType.cast(resource), daoProvider);
        }
    }

    protected abstract void doResolveReferencesForMatching(R var1, DaoProvider var2) throws SQLException;

    protected abstract void modifyIncludeResource(IncludeParts var1, Resource var2, Connection var3);

    protected static class ReferenceValueAndSearchType {
        public final String resourceName;
        public final String id;
        public final String url;
        public final TokenValueAndSearchType identifier;
        public final ReferenceSearchType type;

        private ReferenceValueAndSearchType(String resourceName, String id, String url, TokenValueAndSearchType identifier, ReferenceSearchType type) {
            this.resourceName = resourceName;
            this.id = id;
            this.url = url;
            this.type = type;
            this.identifier = identifier;
        }

        public static Optional<ReferenceValueAndSearchType> fromParamValue(List<String> targetResourceTypeNames, String parameterName, Map<String, List<String>> queryParameters, Consumer<SearchQueryParameterError> errors) {
            ArrayList<String> allValues = new ArrayList<String>();
            allValues.addAll(queryParameters.getOrDefault(parameterName, Collections.emptyList()));
            allValues.addAll(queryParameters.getOrDefault(parameterName + AbstractReferenceParameter.PARAMETER_NAME_IDENTIFIER_MODIFIER, Collections.emptyList()));
            allValues.addAll(targetResourceTypeNames.stream().flatMap(type -> queryParameters.getOrDefault(parameterName + ":" + type, Collections.emptyList()).stream()).collect(Collectors.toList()));
            if (allValues.size() > 1) {
                errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, parameterName, allValues));
            } else if (allValues.isEmpty()) {
                return Optional.empty();
            }
            String value = (String)allValues.get(0);
            if (queryParameters.containsKey(parameterName)) {
                if (value.indexOf(47) == -1 && targetResourceTypeNames.size() == 1) {
                    return Optional.of(new ReferenceValueAndSearchType(targetResourceTypeNames.get(0), value, null, null, ReferenceSearchType.ID));
                }
                if (value.indexOf(47) == -1 && targetResourceTypeNames.size() > 1) {
                    return Optional.of(new ReferenceValueAndSearchType(null, value, null, null, ReferenceSearchType.ID));
                }
                if (value.startsWith("http")) {
                    return Optional.of(new ReferenceValueAndSearchType(null, null, value, null, ReferenceSearchType.URL));
                }
                if (value.indexOf(47) >= 0) {
                    String[] splitAtSlash = value.split("/");
                    if (splitAtSlash.length == 2 && targetResourceTypeNames.stream().anyMatch(name -> name.equals(splitAtSlash[0]))) {
                        return Optional.of(new ReferenceValueAndSearchType(splitAtSlash[0], splitAtSlash[1], null, null, ReferenceSearchType.RESOURCE_NAME_AND_ID));
                    }
                    errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName), "Unsupported target resource type name " + splitAtSlash[0] + ", not one of " + targetResourceTypeNames));
                } else {
                    errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName)));
                }
            } else if (targetResourceTypeNames.stream().anyMatch(type -> queryParameters.containsKey(parameterName + ":" + type))) {
                String paramType = targetResourceTypeNames.stream().filter(type -> queryParameters.containsKey(parameterName + ":" + type)).findFirst().get();
                if (value.indexOf(47) == -1 && targetResourceTypeNames.size() == 1) {
                    if (paramType.equals(targetResourceTypeNames.get(0))) {
                        return Optional.of(new ReferenceValueAndSearchType(paramType, value, null, null, ReferenceSearchType.TYPE_AND_ID));
                    }
                    errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName), "Unsupported target resource type name " + paramType + ", not equal to " + targetResourceTypeNames.get(0)));
                } else if (value.indexOf(47) >= 0) {
                    String[] splitAtSlash = value.split("/");
                    if (splitAtSlash.length == 2 && targetResourceTypeNames.stream().anyMatch(name -> name.equals(splitAtSlash[0]))) {
                        if (paramType.equals(splitAtSlash[0])) {
                            return Optional.of(new ReferenceValueAndSearchType(splitAtSlash[0], splitAtSlash[1], null, null, ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID));
                        }
                        errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName), "Inconsistent target resource type name " + paramType + " vs. " + splitAtSlash[0]));
                    } else {
                        errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName), "Unsupported target resource type name " + splitAtSlash[0] + ", not one of " + targetResourceTypeNames));
                    }
                }
            } else if (queryParameters.containsKey(parameterName + AbstractReferenceParameter.PARAMETER_NAME_IDENTIFIER_MODIFIER)) {
                if (value != null && !value.isBlank()) {
                    return TokenValueAndSearchType.fromParamValue(parameterName + AbstractReferenceParameter.PARAMETER_NAME_IDENTIFIER_MODIFIER, queryParameters, errors).map(identifier -> new ReferenceValueAndSearchType(null, null, null, (TokenValueAndSearchType)identifier, ReferenceSearchType.IDENTIFIER));
                }
                if (value == null || value.isBlank()) {
                    errors.accept(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameters.get(parameterName), "Value empty"));
                }
            }
            return Optional.empty();
        }
    }

    protected static enum ReferenceSearchType {
        ID,
        TYPE_AND_ID,
        RESOURCE_NAME_AND_ID,
        TYPE_AND_RESOURCE_NAME_AND_ID,
        URL,
        IDENTIFIER;

    }
}

