/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractCanonicalReferenceParameter<R extends DomainResource>
extends AbstractReferenceParameter<R> {
    public AbstractCanonicalReferenceParameter(Class<R> resourceType, String resourceTypeName, String parameterName, String ... targetResourceTypeNames) {
        super(resourceType, resourceTypeName, parameterName, targetResourceTypeNames);
    }

    @Override
    protected void configureSearchParameter(Map<String, List<String>> queryParameters) {
        super.configureSearchParameter(queryParameters);
        if (this.valueAndType != null && this.valueAndType.type != null) {
            switch (this.valueAndType.type) {
                case URL: {
                    return;
                }
                case ID: 
                case TYPE_AND_ID: {
                    this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList(this.valueAndType.id)));
                    return;
                }
                case IDENTIFIER: {
                    if (this.valueAndType.identifier != null && this.valueAndType.identifier.type != null) {
                        switch (this.valueAndType.identifier.type) {
                            case CODE: {
                                this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList(this.valueAndType.identifier.codeValue)));
                                return;
                            }
                            case CODE_AND_NO_SYSTEM_PROPERTY: {
                                this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList("|" + this.valueAndType.identifier.codeValue)));
                                return;
                            }
                            case CODE_AND_SYSTEM: {
                                this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList(this.valueAndType.identifier.systemValue + "|" + this.valueAndType.identifier.codeValue)));
                                return;
                            }
                            case SYSTEM: {
                                this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList(this.valueAndType.identifier.systemValue + "|")));
                                return;
                            }
                        }
                        return;
                    }
                    return;
                }
                case RESOURCE_NAME_AND_ID: 
                case TYPE_AND_RESOURCE_NAME_AND_ID: {
                    this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, Collections.singletonList(this.valueAndType.resourceName + "/" + this.valueAndType.id)));
                    return;
                }
            }
            return;
        }
    }
}

