/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractBooleanParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    protected Boolean value;

    public AbstractBooleanParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected void configureSearchParameter(Map<String, List<String>> queryParameters) {
        String param;
        List<String> values = queryParameters.getOrDefault(this.parameterName + AbstractCanonicalUrlParameter.UriSearchType.PRECISE.modifier, Collections.emptyList());
        if (values.size() > 1) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, values));
        }
        if ((param = AbstractBooleanParameter.getFirst(queryParameters, this.parameterName)) != null && !param.isEmpty()) {
            switch (param) {
                case "true": {
                    this.value = true;
                    break;
                }
                case "false": {
                    this.value = false;
                    break;
                }
                default: {
                    this.value = null;
                    this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, values, "true or false expected"));
                }
            }
        }
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        if (this.isDefined()) {
            bundleUri.replaceQueryParam(this.parameterName, new Object[]{String.valueOf(this.value)});
        }
    }
}

