/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/conformance-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the structure definition")
public class StructureDefinitionIdentifier
extends AbstractIdentifierParameter<StructureDefinition> {
    public static final String RESOURCE_COLUMN = "structure_definition";

    public StructureDefinitionIdentifier() {
        super(RESOURCE_COLUMN);
    }

    public StructureDefinitionIdentifier(String resourceColumn) {
        super(resourceColumn);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition s = (StructureDefinition)resource;
        return this.identifierMatches(s.getIdentifier());
    }
}

