/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Questionnaire-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the questionnaire")
public class QuestionnaireIdentifier
extends AbstractIdentifierParameter<Questionnaire> {
    public static final String RESOURCE_COLUMN = "questionnaire";

    public QuestionnaireIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Questionnaire)) {
            return false;
        }
        Questionnaire q = (Questionnaire)resource;
        return this.identifierMatches(q.getIdentifier());
    }
}

