/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Library-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the library")
public class LibraryIdentifier
extends AbstractIdentifierParameter<Library> {
    public static final String RESOURCE_COLUMN = "library";

    public LibraryIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Library)) {
            return false;
        }
        Library l = (Library)resource;
        return this.identifierMatches(l.getIdentifier());
    }
}

