/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/HealthcareService-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifiers for this item")
public class HealthcareServiceIdentifier
extends AbstractIdentifierParameter<HealthcareService> {
    public static final String RESOURCE_COLUMN = "healthcare_service";

    public HealthcareServiceIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof HealthcareService)) {
            return false;
        }
        HealthcareService h = (HealthcareService)resource;
        return this.identifierMatches(h.getIdentifier());
    }
}

