/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Bundle-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="Persistent identifier for the bundle")
public class BundleIdentifier
extends AbstractTokenParameter<Bundle> {
    public static final String PARAMETER_NAME = "identifier";

    public BundleIdentifier() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case CODE: 
            case CODE_AND_SYSTEM: 
            case SYSTEM: {
                return "bundle->'identifier' " + (this.valueAndType.negated ? "<>" : "=") + " ?::jsonb";
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                if (this.valueAndType.negated) {
                    return "bundle->'identifier'->>'value' <> ? OR (bundle->'identifier' ?? 'system')";
                }
                return "bundle->'identifier'->>'value' = ? AND NOT (bundle->'identifier' ?? 'system')";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\"}");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "{\"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
        }
    }

    private boolean identifierMatches(Identifier identifier) {
        if (this.valueAndType.negated) {
            return !AbstractIdentifierParameter.identifierMatches(this.valueAndType, identifier);
        }
        return AbstractIdentifierParameter.identifierMatches(this.valueAndType, identifier);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(bundle->'identifier'->>'system')::text || (bundle->'identifier'->>'value')::text" + sortDirectionWithSpacePrefix;
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Bundle)) {
            return false;
        }
        Bundle e = (Bundle)resource;
        return this.identifierMatches(e.getIdentifier());
    }
}

