/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.filter;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.search.filter.AbstractIdentityFilter;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class TaskIdentityFilter
extends AbstractIdentityFilter {
    private static final String RESOURCE_COLUMN = "task";
    private final String resourceColumn;

    public TaskIdentityFilter(Identity identity) {
        super(identity, null, null);
        this.resourceColumn = RESOURCE_COLUMN;
    }

    public TaskIdentityFilter(Identity identity, String resourceColumn) {
        super(identity, null, null);
        this.resourceColumn = resourceColumn;
    }

    @Override
    public String getFilterQuery() {
        if (this.identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            return "(" + this.resourceColumn + "->'requester'->>'reference' = ? OR " + this.resourceColumn + "->'requester'->>'reference' = ? OR " + this.resourceColumn + "->'restriction'->'recipient' @> ?::jsonb OR " + this.resourceColumn + "->'restriction'->'recipient' @> ?::jsonb)";
        }
        return "FALSE";
    }

    @Override
    public int getSqlParameterCount() {
        return this.identity.hasDsfRole((DsfRole)FhirServerRole.READ) ? 4 : 0;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement) throws SQLException {
        if (this.identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            if (subqueryParameterIndex == 1) {
                statement.setString(parameterIndex, this.identity.getOrganization().getIdElement().getValue());
            } else if (subqueryParameterIndex == 2) {
                statement.setString(parameterIndex, this.identity.getOrganization().getIdElement().toVersionless().getValue());
            } else if (subqueryParameterIndex == 3) {
                statement.setString(parameterIndex, "[{\"reference\": \"" + this.identity.getOrganization().getIdElement().getValue() + "\"}]");
            } else if (subqueryParameterIndex == 4) {
                statement.setString(parameterIndex, "[{\"reference\": \"" + this.identity.getOrganization().getIdElement().toVersionless().getValue() + "\"}]");
            }
        }
    }
}

