/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import java.util.List;

public class SearchQueryParameterError {
    private final SearchQueryParameterErrorType type;
    private final String parameterName;
    private final List<String> parameterValues;
    private final Exception exception;
    private final String message;

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, List<String> parameterValues) {
        this(type, parameterName, parameterValues, null, null);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, List<String> parameterValues, String message) {
        this(type, parameterName, parameterValues, null, message);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, List<String> parameterValues, Exception exception) {
        this(type, parameterName, parameterValues, exception, null);
    }

    public SearchQueryParameterError(SearchQueryParameterErrorType type, String parameterName, List<String> parameterValues, Exception exception, String message) {
        this.type = type;
        this.parameterName = parameterName;
        this.parameterValues = parameterValues;
        this.exception = exception;
        this.message = message;
    }

    public SearchQueryParameterErrorType getType() {
        return this.type;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("parameter: ");
        b.append(this.parameterName);
        b.append(", error: ");
        b.append((Object)this.type);
        if (this.exception != null || this.message != null) {
            b.append(", message: '");
            if (this.exception != null) {
                b.append(this.exception.getClass().getSimpleName());
                b.append(" - ");
                b.append(this.exception.getMessage());
                b.append("'");
            } else if (this.message != null) {
                b.append(this.message);
                b.append("'");
            }
        }
        if (this.parameterValues != null) {
            b.append(", values: ");
            b.append(this.parameterValues);
        }
        return b.toString();
    }

    public static enum SearchQueryParameterErrorType {
        UNSUPPORTED_PARAMETER,
        UNSUPPORTED_NUMBER_OF_VALUES,
        UNPARSABLE_VALUE;

    }
}

