/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.history;

import dev.dsf.fhir.history.HistoryEntry;
import dev.dsf.fhir.search.PageAndCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class History {
    private final int total;
    private final PageAndCount pageAndCount;
    private final List<HistoryEntry> entries = new ArrayList<HistoryEntry>();

    public History(int total, PageAndCount pageAndCount, Collection<? extends HistoryEntry> entries) {
        this.total = total;
        this.pageAndCount = pageAndCount;
        if (entries != null) {
            this.entries.addAll(entries);
        }
    }

    public int getTotal() {
        return this.total;
    }

    public PageAndCount getPageAndCount() {
        return this.pageAndCount;
    }

    public List<HistoryEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }
}

