/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.jdbc.AbstractResourceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ReadByUrlDaoJdbc;
import dev.dsf.fhir.search.SearchQueryIdentityFilter;
import dev.dsf.fhir.search.parameters.StructureDefinitionDate;
import dev.dsf.fhir.search.parameters.StructureDefinitionIdentifier;
import dev.dsf.fhir.search.parameters.StructureDefinitionStatus;
import dev.dsf.fhir.search.parameters.StructureDefinitionUrl;
import dev.dsf.fhir.search.parameters.StructureDefinitionVersion;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.StructureDefinition;

abstract class AbstractStructureDefinitionDaoJdbc
extends AbstractResourceDaoJdbc<StructureDefinition>
implements StructureDefinitionDao {
    private final ReadByUrlDaoJdbc<StructureDefinition> readByUrl;

    public AbstractStructureDefinitionDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext, String resourceTable, String resourceColumn, String resourceIdColumn, Function<Identity, SearchQueryIdentityFilter> userFilter) {
        super(dataSource, permanentDeleteDataSource, fhirContext, StructureDefinition.class, resourceTable, resourceColumn, resourceIdColumn, userFilter, AbstractStructureDefinitionDaoJdbc.with(() -> new StructureDefinitionDate(resourceColumn), () -> new StructureDefinitionIdentifier(resourceColumn), () -> new StructureDefinitionStatus(resourceColumn), () -> new StructureDefinitionUrl(resourceColumn), () -> new StructureDefinitionVersion(resourceColumn)), AbstractStructureDefinitionDaoJdbc.with(new Supplier[0]));
        this.readByUrl = new ReadByUrlDaoJdbc<StructureDefinition>(this::getDataSource, this::getResource, resourceTable, resourceColumn);
    }

    @Override
    public Optional<StructureDefinition> readByUrlAndVersion(String urlAndVersion) throws SQLException {
        return this.readByUrl.readByUrlAndVersion(urlAndVersion);
    }

    @Override
    public Optional<StructureDefinition> readByUrlAndVersionWithTransaction(Connection connection, String urlAndVersion) throws SQLException {
        return this.readByUrl.readByUrlAndVersionWithTransaction(connection, urlAndVersion);
    }

    @Override
    public Optional<StructureDefinition> readByUrlAndVersion(String url, String version) throws SQLException {
        return this.readByUrl.readByUrlAndVersion(url, version);
    }

    @Override
    public Optional<StructureDefinition> readByUrlAndVersionWithTransaction(Connection connection, String url, String version) throws SQLException {
        return this.readByUrl.readByUrlAndVersionWithTransaction(connection, url, version);
    }
}

