/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.validation.ResourceValidator;
import jakarta.ws.rs.WebApplicationException;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHelperImpl
implements ValidationHelper {
    private static final Logger logger = LoggerFactory.getLogger(ValidationHelperImpl.class);
    private final ResourceValidator resourceValidator;
    private final ResponseGenerator responseGenerator;

    public ValidationHelperImpl(ResourceValidator resourceValidator, ResponseGenerator responseGenerator) {
        this.resourceValidator = resourceValidator;
        this.responseGenerator = responseGenerator;
    }

    @Override
    public ValidationResult checkResourceValidForCreate(Identity identity, Resource resource) {
        return this.checkResourceValid(identity, resource, "Create");
    }

    @Override
    public ValidationResult checkResourceValidForUpdate(Identity identity, Resource resource) {
        return this.checkResourceValid(identity, resource, "Update");
    }

    private ValidationResult checkResourceValid(Identity identity, Resource resource, String method) {
        ValidationResult validationResult = this.resourceValidator.validate(resource);
        if (validationResult.getMessages().stream().anyMatch(m -> ResultSeverityEnum.ERROR.equals((Object)m.getSeverity()) || ResultSeverityEnum.FATAL.equals((Object)m.getSeverity()))) {
            logger.warn("{} of {} unauthorized, resource not valid: {}", new Object[]{method, resource.fhirType(), this.toValidationLogMessage(validationResult)});
            throw new WebApplicationException(this.responseGenerator.forbiddenNotValid(method, identity, resource.fhirType(), validationResult));
        }
        if (!validationResult.getMessages().isEmpty()) {
            logger.info("Resource {} validated with messages: {}", (Object)resource.fhirType(), (Object)this.toValidationLogMessage(validationResult));
        }
        return validationResult;
    }

    private String toValidationLogMessage(ValidationResult validationResult) {
        return validationResult.getMessages().stream().map(m -> m.getLocationString() + " " + m.getLocationLine() + ":" + m.getLocationCol() + " - " + m.getSeverity() + ": " + m.getMessage()).collect(Collectors.joining(", ", "[", "]"));
    }
}

