/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.NamingSystemDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingSystemAuthorizationRule
extends AbstractMetaTagAuthorizationRule<NamingSystem, NamingSystemDao> {
    private static final Logger logger = LoggerFactory.getLogger(NamingSystemAuthorizationRule.class);

    public NamingSystemAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(NamingSystem.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, NamingSystem newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, NamingSystem newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Identity identity, NamingSystem newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.hasStatus()) {
            if (!EnumSet.of(Enumerations.PublicationStatus.DRAFT, Enumerations.PublicationStatus.ACTIVE, Enumerations.PublicationStatus.RETIRED).contains(newResource.getStatus())) {
                errors.add("NamingSystem.status not one of DRAFT, ACTIVE or RETIRED");
            }
        } else {
            errors.add("NamingSystem.status not defined");
        }
        if (!newResource.hasName()) {
            errors.add("NamingSystem.name not defined");
        }
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("NamingSystem is missing valid read access tag");
        }
        if (!this.hasOnlyUniqueUriUniqueIds(newResource)) {
            errors.add("NamingSystem has non unique ids");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private boolean hasOnlyUniqueUriUniqueIds(NamingSystem newResource) {
        long distinctUriCount;
        long uriCount = newResource.getUniqueId().stream().filter(NamingSystem.NamingSystemUniqueIdComponent::hasType).filter(id -> NamingSystem.NamingSystemIdentifierType.URI.equals((Object)id.getType())).count();
        return uriCount == (distinctUriCount = newResource.getUniqueId().stream().filter(NamingSystem.NamingSystemUniqueIdComponent::hasType).filter(id -> NamingSystem.NamingSystemIdentifierType.URI.equals((Object)id.getType())).map(NamingSystem.NamingSystemUniqueIdComponent::getValue).distinct().count());
    }

    @Override
    protected boolean resourceExists(Connection connection, NamingSystem newResource) {
        try {
            boolean withNameExists = ((NamingSystemDao)this.getDao()).readByNameWithTransaction(connection, newResource.getName()).isPresent();
            boolean withUniqueIdUriExists = newResource.getUniqueId().stream().filter(NamingSystem.NamingSystemUniqueIdComponent::hasType).filter(id -> NamingSystem.NamingSystemIdentifierType.URI.equals((Object)id.getType())).filter(NamingSystem.NamingSystemUniqueIdComponent::hasValue).map(NamingSystem.NamingSystemUniqueIdComponent::getValue).anyMatch(this.resourceWithUniquIdUriEntryExists(connection));
            return withNameExists || withUniqueIdUriExists;
        }
        catch (SQLException e) {
            logger.warn("Error while searching for NamingSystem", (Throwable)e);
            return false;
        }
    }

    private Predicate<String> resourceWithUniquIdUriEntryExists(Connection connection) {
        return uniqueIdValue -> {
            try {
                return ((NamingSystemDao)this.getDao()).existsWithUniqueIdUriEntry(connection, (String)uniqueIdValue);
            }
            catch (SQLException e) {
                logger.warn("Error while searching for NamingSystem", (Throwable)e);
                return false;
            }
        };
    }

    @Override
    protected boolean modificationsOk(Connection connection, NamingSystem oldResource, NamingSystem newResource) {
        return oldResource.getName().equals(newResource.getName());
    }
}

