/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.HealthcareServiceDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Resource;

public class HealthcareServiceAuthorizationRule
extends AbstractMetaTagAuthorizationRule<HealthcareService, HealthcareServiceDao> {
    public HealthcareServiceAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(HealthcareService.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, HealthcareService newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, HealthcareService newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Identity identity, HealthcareService newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("HealthcareService is missing valid read access tag");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean resourceExists(Connection connection, HealthcareService newResource) {
        return false;
    }

    @Override
    protected boolean modificationsOk(Connection connection, HealthcareService oldResource, HealthcareService newResource) {
        return true;
    }
}

