/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.RoleConfig;
import dev.dsf.fhir.authentication.AbstractProvider;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationIdentityImpl;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authentication.PractitionerIdentityImpl;
import dev.dsf.fhir.authentication.PractitionerProvider;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class IdentityProviderImpl
extends AbstractProvider
implements IdentityProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(IdentityProviderImpl.class);
    private final OrganizationProvider organizationProvider;
    private final PractitionerProvider practitionerProvider;
    private final String localOrganizationIdentifierValue;
    private final RoleConfig roleConfig;

    public IdentityProviderImpl(OrganizationProvider organizationProvider, PractitionerProvider practitionerProvider, String localOrganizationIdentifierValue, RoleConfig roleConfig) {
        this.organizationProvider = organizationProvider;
        this.practitionerProvider = practitionerProvider;
        this.localOrganizationIdentifierValue = localOrganizationIdentifierValue;
        this.roleConfig = roleConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.organizationProvider, "organizationProvider");
        Objects.requireNonNull(this.practitionerProvider, "practitionerProvider");
        Objects.requireNonNull(this.localOrganizationIdentifierValue, "localOrganizationIdentifierValue");
        Objects.requireNonNull(this.roleConfig, "roleConfig");
    }

    public Identity getIdentity(DsfOpenIdCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        Optional<Practitioner> practitioner = this.practitionerProvider.getPractitioner(credentials);
        Optional<Organization> localOrganization = this.organizationProvider.getLocalOrganization();
        if (practitioner.isPresent() && localOrganization.isPresent()) {
            Map parsedIdToken = credentials.getIdToken();
            Map parsedAccessToken = credentials.getAccessToken();
            List<String> rolesFromTokens = this.getRolesFromTokens(parsedIdToken, parsedAccessToken);
            List<String> groupsFromTokens = this.getGroupsFromTokens(parsedIdToken, parsedAccessToken);
            Set<DsfRole> dsfRoles = this.getDsfRolesFor(practitioner.get(), null, rolesFromTokens, groupsFromTokens);
            Set<Coding> practitionerRoles = this.getPractitionerRolesFor(practitioner.get(), null, rolesFromTokens, groupsFromTokens);
            return new PractitionerIdentityImpl(localOrganization.get(), dsfRoles, null, practitioner.get(), practitionerRoles, credentials);
        }
        logger.warn("User from OpenID Connect token '{}' not configured as local user or local organization unknown", (Object)credentials.getUserId());
        return null;
    }

    private List<String> getGroupsFromTokens(Map<String, Object> parsedIdToken, Map<String, Object> parsedAccessToken) {
        if (logger.isDebugEnabled()) {
            logger.debug("id_token: groups: {}", this.getPropertyArray(parsedIdToken, "groups"));
            logger.debug("access_token: groups: {}", this.getPropertyArray(parsedAccessToken, "groups"));
        }
        return Stream.concat(this.getPropertyArray(parsedIdToken, "groups").stream(), this.getPropertyArray(parsedAccessToken, "groups").stream()).toList();
    }

    private List<String> getRolesFromTokens(Map<String, Object> idToken, Map<String, Object> accessToken) {
        return Stream.concat(this.getRolesFromToken("id_token", idToken), this.getRolesFromToken("access_token", accessToken)).toList();
    }

    private Stream<String> getRolesFromToken(String tokenName, Map<String, Object> token) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: realm_access.roles: {}", (Object)tokenName, this.getPropertyArray(this.getPropertyMap(token, "realm_access"), "roles"));
            logger.debug("{}: resource_access.*.roles: {}", (Object)tokenName, this.getPropertyMap(token, "resource_access").entrySet().stream().flatMap(e -> this.getPropertyArray((Map)e.getValue(), "roles").stream().map(r -> (String)e.getKey() + "." + r)).toList());
        }
        return Stream.concat(this.getPropertyArray(this.getPropertyMap(token, "realm_access"), "roles").stream(), this.getPropertyMap(token, "resource_access").entrySet().stream().flatMap(e -> this.getPropertyArray((Map)e.getValue(), "roles").stream().map(r -> (String)e.getKey() + "." + r)));
    }

    private Map<String, Object> getPropertyMap(Map<String, Object> map, String property) {
        Object propertyValue = map.get(property);
        if (propertyValue != null && propertyValue instanceof Map) {
            return (Map)propertyValue;
        }
        return Collections.emptyMap();
    }

    private List<String> getPropertyArray(Map<String, Object> map, String property) {
        Object propertyValue = map.get(property);
        if (propertyValue != null && propertyValue instanceof Object[]) {
            return Arrays.stream((Object[])propertyValue).filter(v -> v instanceof String).map(v -> (String)v).toList();
        }
        return Collections.emptyList();
    }

    public Identity getIdentity(X509Certificate[] certificates) {
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        String thumbprint = this.getThumbprint(certificates[0]);
        Optional<Organization> organization = this.organizationProvider.getOrganization(certificates[0]);
        if (organization.isPresent()) {
            boolean localOrganization = this.isLocalOrganization(organization.get());
            if (localOrganization) {
                return new OrganizationIdentityImpl(true, organization.get(), FhirServerRole.LOCAL_ORGANIZATION, certificates[0]);
            }
            return new OrganizationIdentityImpl(false, organization.get(), FhirServerRole.REMOTE_ORGANIZATION, certificates[0]);
        }
        Optional<Practitioner> practitioner = this.practitionerProvider.getPractitioner(certificates[0]);
        Optional<Organization> localOrganization = this.organizationProvider.getLocalOrganization();
        if (practitioner.isPresent() && localOrganization.isPresent()) {
            Practitioner p = practitioner.get();
            Organization o = localOrganization.get();
            return new PractitionerIdentityImpl(o, this.getDsfRolesFor(p, thumbprint, null, null), certificates[0], p, this.getPractitionerRolesFor(p, thumbprint, null, null), null);
        }
        logger.warn("Certificate with thumbprint '{}' for '{}' unknown, not part of allowlist and not configured as local user or local organization", (Object)thumbprint, (Object)this.getDn(certificates[0]));
        return null;
    }

    private boolean isLocalOrganization(Organization organization) {
        return organization != null && organization.getIdentifier().stream().filter(i -> i != null).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).anyMatch(i -> this.localOrganizationIdentifierValue.equals(i.getValue()));
    }

    private Set<DsfRole> getDsfRolesFor(Practitioner practitioner, String thumbprint, List<String> tokenRoles, List<String> tokenGroups) {
        Stream<String> emailAddresses = practitioner.getIdentifier().stream().filter(i -> "http://dsf.dev/sid/practitioner-identifier".equals(i.getSystem()) && i.hasValue()).map(Identifier::getValue);
        Stream r1 = emailAddresses.map(arg_0 -> ((RoleConfig)this.roleConfig).getDsfRolesForEmail(arg_0)).flatMap(Collection::stream);
        Stream r2 = thumbprint == null ? Stream.empty() : this.roleConfig.getDsfRolesForThumbprint(thumbprint).stream();
        Stream r3 = tokenRoles == null ? Stream.empty() : tokenRoles.stream().map(arg_0 -> ((RoleConfig)this.roleConfig).getDsfRolesForTokenRole(arg_0)).flatMap(Collection::stream);
        Stream r4 = tokenGroups == null ? Stream.empty() : tokenGroups.stream().map(arg_0 -> ((RoleConfig)this.roleConfig).getDsfRolesForTokenGroup(arg_0)).flatMap(Collection::stream);
        return Stream.of(r1, r2, r3, r4).flatMap(Function.identity()).distinct().collect(Collectors.toSet());
    }

    private Set<Coding> getPractitionerRolesFor(Practitioner practitioner, String thumbprint, List<String> tokenRoles, List<String> tokenGroups) {
        Stream<String> emailAddresses = practitioner.getIdentifier().stream().filter(i -> "http://dsf.dev/sid/practitioner-identifier".equals(i.getSystem()) && i.hasValue()).map(Identifier::getValue);
        Stream r1 = emailAddresses.map(arg_0 -> ((RoleConfig)this.roleConfig).getPractitionerRolesForEmail(arg_0)).flatMap(Collection::stream);
        Stream r2 = thumbprint == null ? Stream.empty() : this.roleConfig.getPractitionerRolesForThumbprint(thumbprint).stream();
        Stream r3 = tokenRoles == null ? Stream.empty() : tokenRoles.stream().map(arg_0 -> ((RoleConfig)this.roleConfig).getPractitionerRolesForTokenRole(arg_0)).flatMap(Collection::stream);
        Stream r4 = tokenGroups == null ? Stream.empty() : tokenGroups.stream().map(arg_0 -> ((RoleConfig)this.roleConfig).getPractitionerRolesForTokenGroup(arg_0)).flatMap(Collection::stream);
        return Stream.of(r1, r2, r3, r4).flatMap(Function.identity()).distinct().collect(Collectors.toSet());
    }
}

