/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import de.rwh.utils.crypto.CertificateHelper;
import de.rwh.utils.crypto.io.CertificateReader;
import de.rwh.utils.crypto.io.PemIo;
import dev.dsf.fhir.client.ClientProvider;
import dev.dsf.fhir.client.ClientProviderImpl;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import dev.dsf.fhir.spring.config.ReferenceConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClientConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfig.class);
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private ReferenceConfig referenceConfig;

    @Bean
    public ClientProvider clientProvider() {
        char[] keyStorePassword = UUID.randomUUID().toString().toCharArray();
        try {
            KeyStore webserviceKeyStore = this.createKeyStore(this.propertiesConfig.getWebserviceClientCertificateFile(), this.propertiesConfig.getWebserviceClientCertificatePrivateKeyFile(), this.propertiesConfig.getWebserviceClientCertificatePrivateKeyFilePassword(), keyStorePassword);
            KeyStore webserviceTrustStore = this.createTrustStore(this.propertiesConfig.getWebserviceClientCertificateTrustCertificatesFile());
            return new ClientProviderImpl(webserviceTrustStore, webserviceKeyStore, keyStorePassword, this.propertiesConfig.getWebserviceClientReadTimeout(), this.propertiesConfig.getWebserviceClientConnectTimeout(), this.propertiesConfig.proxyConfig(), this.propertiesConfig.getWebserviceClientVerbose(), this.fhirConfig.fhirContext(), this.referenceConfig.referenceCleaner(), this.daoConfig.endpointDao(), this.helperConfig.exceptionHandler());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | PKCSException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore createTrustStore(String trustStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Path trustStorePath = Paths.get(trustStoreFile, new String[0]);
        if (!Files.isReadable(trustStorePath)) {
            throw new IOException("Trust store file '" + trustStorePath.toString() + "' not readable");
        }
        return CertificateReader.allFromCer((Path)trustStorePath);
    }

    private KeyStore createKeyStore(String certificateFile, String privateKeyFile, char[] privateKeyPassword, char[] keyStorePassword) throws IOException, PKCSException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Path certificatePath = Paths.get(certificateFile, new String[0]);
        Path privateKeyPath = Paths.get(privateKeyFile, new String[0]);
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Certificate file '" + certificatePath.toString() + "' not readable");
        }
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Private key file '" + privateKeyPath.toString() + "' not readable");
        }
        X509Certificate certificate = PemIo.readX509CertificateFromPem((Path)certificatePath);
        PrivateKey privateKey = PemIo.readPrivateKeyFromPem((BouncyCastleProvider)provider, (Path)privateKeyPath, (char[])privateKeyPassword);
        String subjectCommonName = CertificateHelper.getSubjectCommonName((X509Certificate)certificate);
        return CertificateHelper.toJksKeyStore((PrivateKey)privateKey, (Certificate[])new Certificate[]{certificate}, (String)subjectCommonName, (char[])keyStorePassword);
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Remote webservice client config: {trustStorePath: {}, certificatePath: {}, privateKeyPath: {}, privateKeyPassword: {}, proxy: {}, no_proxy: {}}", new Object[]{this.propertiesConfig.getWebserviceClientCertificateTrustCertificatesFile(), this.propertiesConfig.getWebserviceClientCertificateFile(), this.propertiesConfig.getWebserviceClientCertificatePrivateKeyFile(), this.propertiesConfig.getWebserviceClientCertificatePrivateKeyFilePassword() != null ? "***" : "null", this.propertiesConfig.proxyConfig().isEnabled() ? "enabled" : "disabled", this.propertiesConfig.proxyConfig().getNoProxyUrls()});
    }
}

