/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractDateTimeParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    private static final Pattern YEAR_PATTERN = Pattern.compile("[0-9]{4}");
    private static final Pattern YEAR_MONTH_PATTERN = Pattern.compile("([0-9]{4})-([0-9]{2})");
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ISO_DATE_TIME;
    private static final DateTimeFormatter DATE_TIME_FORMAT_OUT = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter YEAR_FORMAT = DateTimeFormatter.ofPattern("yyyy");
    private static final DateTimeFormatter YEAR_MONTH_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM");
    private List<DateTimeValueAndTypeAndSearchType> valuesAndTypes = new ArrayList<DateTimeValueAndTypeAndSearchType>();
    private final String timestampColumn;
    private final List<Object> values = new ArrayList<Object>();

    public AbstractDateTimeParameter(String parameterName, String timestampColumn) {
        super(parameterName);
        this.timestampColumn = timestampColumn;
    }

    @Override
    protected final void configureSearchParameter(Map<String, List<String>> queryParameters) {
        DateTimeValueAndTypeAndSearchType second;
        List<String> parameters = queryParameters.getOrDefault(this.parameterName, Collections.emptyList());
        parameters.stream().limit(2L).map(value -> this.parse((String)value, parameters)).filter(v -> v != null).collect(Collectors.toCollection(() -> this.valuesAndTypes));
        DateTimeValueAndTypeAndSearchType first = this.valuesAndTypes.size() < 1 ? null : this.valuesAndTypes.get(0);
        DateTimeValueAndTypeAndSearchType dateTimeValueAndTypeAndSearchType = second = this.valuesAndTypes.size() < 2 ? null : this.valuesAndTypes.get(1);
        if (parameters.size() > 2) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, parameters, "More than two " + this.parameterName + " values"));
        } else if (!(this.valuesAndTypes.size() != 2 || EnumSet.of(DateTimeSearchType.GE, DateTimeSearchType.GT).contains((Object)first.searchType) && EnumSet.of(DateTimeSearchType.LE, DateTimeSearchType.LT).contains((Object)second.searchType) || EnumSet.of(DateTimeSearchType.GE, DateTimeSearchType.GT).contains((Object)second.searchType) && EnumSet.of(DateTimeSearchType.LE, DateTimeSearchType.LT).contains((Object)first.searchType))) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, parameters, "Seach operators " + first.searchType + " and " + second.searchType + " can't be combined"));
        }
        if (!(this.valuesAndTypes.size() <= 1 || EnumSet.of(DateTimeSearchType.GE, DateTimeSearchType.GT).contains((Object)first.searchType) && EnumSet.of(DateTimeSearchType.LE, DateTimeSearchType.LT).contains((Object)second.searchType) || EnumSet.of(DateTimeSearchType.GE, DateTimeSearchType.GT).contains((Object)second.searchType) && EnumSet.of(DateTimeSearchType.LE, DateTimeSearchType.LT).contains((Object)first.searchType))) {
            this.valuesAndTypes.clear();
            this.valuesAndTypes.add(first);
        }
        this.checkParameters(parameters);
    }

    protected void checkParameters(List<String> parameters) {
    }

    private DateTimeValueAndTypeAndSearchType parse(String parameterValue, List<String> parameterValues) {
        String fixedParameterValue = parameterValue.replace(' ', '+');
        if (Arrays.stream(DateTimeSearchType.values()).map(t -> t.prefix).anyMatch(prefix -> fixedParameterValue.toLowerCase().startsWith((String)prefix))) {
            String prefix2 = fixedParameterValue.substring(0, 2);
            String value = fixedParameterValue.substring(2, fixedParameterValue.length()).toUpperCase();
            return this.parseValue(value, DateTimeSearchType.valueOf(prefix2.toUpperCase()), fixedParameterValue, parameterValues);
        }
        return this.parseValue(fixedParameterValue, DateTimeSearchType.EQ, fixedParameterValue, parameterValues);
    }

    private DateTimeValueAndTypeAndSearchType parseValue(String value, DateTimeSearchType searchType, String parameterValue, List<String> parameterValues) {
        try {
            return new DateTimeValueAndTypeAndSearchType(ZonedDateTime.parse(value, DATE_TIME_FORMAT), DateTimeType.ZONED_DATE_TIME, searchType);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return new DateTimeValueAndTypeAndSearchType(ZonedDateTime.parse(value, DATE_TIME_FORMAT.withZone(ZoneId.systemDefault())), DateTimeType.ZONED_DATE_TIME, searchType);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return new DateTimeValueAndTypeAndSearchType(LocalDate.parse(value, DATE_FORMAT), DateTimeType.LOCAL_DATE, searchType);
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    if (DateTimeSearchType.EQ.equals((Object)searchType)) {
                        Matcher yearMonthMatcher = YEAR_MONTH_PATTERN.matcher(value);
                        if (yearMonthMatcher.matches()) {
                            int year = Integer.parseInt(yearMonthMatcher.group(1));
                            int month = Integer.parseInt(yearMonthMatcher.group(2));
                            return new DateTimeValueAndTypeAndSearchType(new LocalDatePair(LocalDate.of(year, month, 1), LocalDate.of(year, month, 1).plusMonths(1L)), DateTimeType.YEAR_MONTH_PERIOD, DateTimeSearchType.EQ);
                        }
                        Matcher yearMatcher = YEAR_PATTERN.matcher(value);
                        if (yearMatcher.matches()) {
                            int year = Integer.parseInt(yearMatcher.group());
                            return new DateTimeValueAndTypeAndSearchType(new LocalDatePair(LocalDate.of(year, 1, 1), LocalDate.of(year, 1, 1).plusYears(1L)), DateTimeType.YEAR_PERIOD, DateTimeSearchType.EQ);
                        }
                    }
                    this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, parameterValues, parameterValue + " not parsable"));
                    return null;
                }
            }
        }
    }

    public List<DateTimeValueAndTypeAndSearchType> getValuesAndTypes() {
        return this.valuesAndTypes;
    }

    @Override
    public boolean isDefined() {
        return !this.valuesAndTypes.isEmpty();
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        bundleUri.replaceQueryParam(this.parameterName, this.valuesAndTypes.stream().map(value -> value.searchType.prefix + this.toUrlValue((DateTimeValueAndTypeAndSearchType)value)).toArray());
    }

    private String toUrlValue(DateTimeValueAndTypeAndSearchType value) {
        switch (value.type) {
            case ZONED_DATE_TIME: {
                return ((ZonedDateTime)value.value).format(DATE_TIME_FORMAT_OUT);
            }
            case LOCAL_DATE: {
                return ((LocalDate)value.value).format(DATE_FORMAT);
            }
            case YEAR_PERIOD: {
                return ((LocalDatePair)value.value).startInclusive.format(YEAR_FORMAT);
            }
            case YEAR_MONTH_PERIOD: {
                return ((LocalDatePair)value.value).startInclusive.format(YEAR_MONTH_FORMAT);
            }
        }
        return "";
    }

    @Override
    public String getFilterQuery() {
        this.values.clear();
        return this.getValuesAndTypes().stream().map(this::getSubquery).collect(Collectors.joining(" AND "));
    }

    private String getSubquery(DateTimeValueAndTypeAndSearchType value) {
        switch (value.type) {
            case ZONED_DATE_TIME: {
                return this.getSubquery((ZonedDateTime)value.value, value.searchType);
            }
            case LOCAL_DATE: {
                return this.getSubquery((LocalDate)value.value, value.searchType);
            }
            case YEAR_PERIOD: 
            case YEAR_MONTH_PERIOD: {
                return this.getSubquery((LocalDatePair)value.value);
            }
        }
        return "";
    }

    private String getSubquery(ZonedDateTime value, DateTimeSearchType searchType) {
        this.values.add(value);
        return "(" + this.timestampColumn + ")::timestamp " + searchType.operator + " ?";
    }

    private String getSubquery(LocalDate value, DateTimeSearchType searchType) {
        this.values.add(value);
        return "(" + this.timestampColumn + ")::date " + searchType.operator + " ?";
    }

    private String getSubquery(LocalDatePair value) {
        return this.getSubquery(value.startInclusive, DateTimeSearchType.GE) + " AND " + this.getSubquery(value.endExclusive, DateTimeSearchType.LT);
    }

    @Override
    public int getSqlParameterCount() {
        return this.values.size();
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        Object value = this.values.get(subqueryParameterIndex - 1);
        if (value instanceof ZonedDateTime) {
            statement.setTimestamp(parameterIndex, Timestamp.valueOf(((ZonedDateTime)value).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime()));
        } else if (value instanceof LocalDate) {
            statement.setDate(parameterIndex, Date.valueOf((LocalDate)value));
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        ZonedDateTime lastUpdated = this.toZonedDateTime(resource.getMeta().getLastUpdated());
        return lastUpdated != null && this.getValuesAndTypes().stream().allMatch(value -> this.matches(lastUpdated, (DateTimeValueAndTypeAndSearchType)value));
    }

    private ZonedDateTime toZonedDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    private boolean matches(ZonedDateTime lastUpdated, DateTimeValueAndTypeAndSearchType value) {
        switch (value.type) {
            case ZONED_DATE_TIME: {
                return this.matches(lastUpdated, (ZonedDateTime)value.value, value.searchType);
            }
            case LOCAL_DATE: {
                return this.matches(lastUpdated.toLocalDate(), (LocalDate)value.value, value.searchType);
            }
            case YEAR_PERIOD: 
            case YEAR_MONTH_PERIOD: {
                return this.matches(lastUpdated.toLocalDate(), (LocalDatePair)value.value);
            }
        }
        throw this.notDefined();
    }

    private boolean matches(ZonedDateTime lastUpdated, ZonedDateTime value, DateTimeSearchType type) {
        switch (type) {
            case EQ: {
                return lastUpdated.equals(value);
            }
            case GT: {
                return lastUpdated.isAfter(value);
            }
            case GE: {
                return lastUpdated.isAfter(value) || lastUpdated.equals(value);
            }
            case LT: {
                return lastUpdated.isBefore(value);
            }
            case LE: {
                return lastUpdated.isBefore(value) || lastUpdated.equals(value);
            }
            case NE: {
                return !lastUpdated.isEqual(value);
            }
        }
        throw this.notDefined();
    }

    private boolean matches(LocalDate lastUpdated, LocalDate value, DateTimeSearchType type) {
        switch (type) {
            case EQ: {
                return lastUpdated.equals(value);
            }
            case GT: {
                return lastUpdated.isAfter(value);
            }
            case GE: {
                return lastUpdated.isAfter(value) || lastUpdated.equals(value);
            }
            case LT: {
                return lastUpdated.isBefore(value);
            }
            case LE: {
                return lastUpdated.isBefore(value) || lastUpdated.equals(value);
            }
            case NE: {
                return !lastUpdated.isEqual(value);
            }
        }
        throw this.notDefined();
    }

    private boolean matches(LocalDate lastUpdated, LocalDatePair value) {
        return (lastUpdated.isAfter(value.startInclusive) || lastUpdated.isEqual(value.startInclusive)) && lastUpdated.isBefore(value.endExclusive);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(" + this.timestampColumn + ")::timestamp" + sortDirectionWithSpacePrefix;
    }

    protected static class DateTimeValueAndTypeAndSearchType {
        public final Object value;
        public final DateTimeType type;
        public final DateTimeSearchType searchType;

        public DateTimeValueAndTypeAndSearchType(Object value, DateTimeType type, DateTimeSearchType searchType) {
            this.value = value;
            this.type = type;
            this.searchType = searchType;
        }
    }

    public static enum DateTimeSearchType {
        EQ("eq", "="),
        NE("ne", "<>"),
        GT("gt", ">"),
        LT("lt", "<"),
        GE("ge", ">="),
        LE("le", "<=");

        public final String prefix;
        public final String operator;

        private DateTimeSearchType(String prefix, String operator) {
            this.prefix = prefix;
            this.operator = operator;
        }
    }

    protected static enum DateTimeType {
        ZONED_DATE_TIME,
        LOCAL_DATE,
        YEAR_PERIOD,
        YEAR_MONTH_PERIOD;

    }

    protected static class LocalDatePair {
        public final LocalDate startInclusive;
        public final LocalDate endExclusive;

        private LocalDatePair(LocalDate startInclusive, LocalDate endExclusive) {
            this.startInclusive = startInclusive;
            this.endExclusive = endExclusive;
        }

        public String toString() {
            return ">= " + this.startInclusive + " && < " + this.endExclusive;
        }
    }
}

