/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import jakarta.ws.rs.core.UriBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractCanonicalUrlParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    protected CanonicalUrlAndSearchType valueAndType;

    public AbstractCanonicalUrlParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected Stream<String> getModifiedParameterNames() {
        return Stream.of(this.getParameterName() + UriSearchType.BELOW.modifier);
    }

    @Override
    protected final void configureSearchParameter(Map<String, List<String>> queryParameters) {
        String precise;
        ArrayList<String> allValues = new ArrayList<String>();
        allValues.addAll(queryParameters.getOrDefault(this.parameterName + UriSearchType.PRECISE.modifier, Collections.emptyList()));
        allValues.addAll(queryParameters.getOrDefault(this.parameterName + UriSearchType.BELOW.modifier, Collections.emptyList()));
        if (allValues.size() > 1) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, allValues));
        }
        if ((precise = AbstractCanonicalUrlParameter.getFirst(queryParameters, this.parameterName + UriSearchType.PRECISE.modifier)) != null) {
            this.valueAndType = AbstractCanonicalUrlParameter.toValueAndType(precise, UriSearchType.PRECISE);
            return;
        }
        String below = AbstractCanonicalUrlParameter.getFirst(queryParameters, this.parameterName + UriSearchType.BELOW.modifier);
        if (below != null) {
            this.valueAndType = AbstractCanonicalUrlParameter.toValueAndType(below, UriSearchType.BELOW);
            return;
        }
    }

    protected static CanonicalUrlAndSearchType toValueAndType(String parameter, UriSearchType type) {
        if (parameter != null && !parameter.isBlank()) {
            String[] split = parameter.split("[|]");
            if (split.length == 1) {
                return new CanonicalUrlAndSearchType(split[0], null, type);
            }
            if (split.length == 2) {
                return new CanonicalUrlAndSearchType(split[0], split[1], type);
            }
        }
        return null;
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    protected boolean hasVersion() {
        return this.isDefined() && this.valueAndType.version != null;
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        bundleUri.replaceQueryParam(this.parameterName + this.valueAndType.type.modifier, new Object[]{this.valueAndType.url + (String)(this.hasVersion() ? "|" + this.valueAndType.version : "")});
    }

    public static enum UriSearchType {
        PRECISE(""),
        BELOW(":below");

        public final String modifier;

        private UriSearchType(String modifier) {
            this.modifier = modifier;
        }
    }

    protected static class CanonicalUrlAndSearchType {
        public final String url;
        public final String version;
        public final UriSearchType type;

        private CanonicalUrlAndSearchType(String url, String version, UriSearchType type) {
            this.url = url;
            this.version = version;
            this.type = type;
        }
    }
}

