/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="status", definition="http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status", type=Enumerations.SearchParamType.TOKEN, documentation="The status of the questionnaire response")
public class QuestionnaireResponseStatus
extends AbstractTokenParameter<QuestionnaireResponse> {
    public static final String PARAMETER_NAME = "status";
    private QuestionnaireResponse.QuestionnaireResponseStatus status;

    public QuestionnaireResponseStatus() {
        super(PARAMETER_NAME);
    }

    @Override
    protected void configureSearchParameter(Map<String, List<String>> queryParameters) {
        super.configureSearchParameter(queryParameters);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.status = this.toStatus(this.valueAndType.codeValue, queryParameters.get(this.parameterName));
        }
    }

    private QuestionnaireResponse.QuestionnaireResponseStatus toStatus(String status, List<String> parameterValues) {
        if (status == null || status.isBlank()) {
            return null;
        }
        try {
            return QuestionnaireResponse.QuestionnaireResponseStatus.fromCode((String)status);
        }
        catch (FHIRException e) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, parameterValues, (Exception)((Object)e)));
            return null;
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.status != null;
    }

    @Override
    public String getFilterQuery() {
        return "questionnaire_response->>'status' " + (this.valueAndType.negated ? "<>" : "=") + " ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.status.toCode());
    }

    @Override
    public void modifyBundleUri(UriBuilder bundleUri) {
        bundleUri.replaceQueryParam(PARAMETER_NAME + (this.valueAndType.negated ? ":not" : ""), new Object[]{this.status.toCode()});
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof QuestionnaireResponse)) {
            return false;
        }
        if (this.valueAndType.negated) {
            return !Objects.equals(((QuestionnaireResponse)resource).getStatus(), this.status);
        }
        return Objects.equals(((QuestionnaireResponse)resource).getStatus(), this.status);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "questionnaire_response->>'status'" + sortDirectionWithSpacePrefix;
    }
}

