/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

@IncludeParameterDefinition(resourceType=PractitionerRole.class, parameterName="organization", targetResourceTypes={Organization.class})
@SearchQueryParameter.SearchParameterDefinition(name="organization", definition="http://hl7.org/fhir/SearchParameter/PractitionerRole-organization", type=Enumerations.SearchParamType.REFERENCE, documentation="The identity of the organization the practitioner represents / acts on behalf of")
public class PractitionerRoleOrganization
extends AbstractReferenceParameter<PractitionerRole> {
    private static final String RESOURCE_TYPE_NAME = "PractitionerRole";
    public static final String PARAMETER_NAME = "organization";
    private static final String TARGET_RESOURCE_TYPE_NAME = "Organization";
    private static final String PRACTITIONER_IDENTIFIERS_SUBQUERY = "(SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = practitioner_role->'organization'->>'reference')";

    public PractitionerRoleOrganization() {
        super(PractitionerRole.class, RESOURCE_TYPE_NAME, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case ID: 
            case RESOURCE_NAME_AND_ID: 
            case URL: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                return "practitioner_role->'organization'->>'reference' = ?";
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: 
                    case CODE_AND_SYSTEM: 
                    case SYSTEM: {
                        return "(SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = practitioner_role->'organization'->>'reference') @> ?::jsonb";
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        return "(SELECT count(*) FROM jsonb_array_elements((SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = practitioner_role->'organization'->>'reference')) identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
                    }
                }
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        block0 : switch (this.valueAndType.type) {
            case ID: 
            case RESOURCE_NAME_AND_ID: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                statement.setString(parameterIndex, "Organization/" + this.valueAndType.id);
                break;
            }
            case URL: {
                statement.setString(parameterIndex, this.valueAndType.url);
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\", \"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        statement.setString(parameterIndex, this.valueAndType.identifier.codeValue);
                        break block0;
                    }
                    case SYSTEM: {
                        statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                    }
                }
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(PractitionerRole resource, DaoProvider daoProvider) throws SQLException {
        OrganizationDao dao = daoProvider.getOrganizationDao();
        Reference reference = resource.getOrganization();
        IIdType idType = reference.getReferenceElement();
        try {
            if (idType.hasVersionIdPart()) {
                dao.readVersion(UUID.fromString(idType.getIdPart()), idType.getVersionIdPartAsLong()).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            } else {
                dao.read(UUID.fromString(idType.getIdPart())).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            }
        }
        catch (ResourceDeletedException resourceDeletedException) {
            // empty catch block
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof PractitionerRole)) {
            return false;
        }
        PractitionerRole pR = (PractitionerRole)resource;
        if (AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER.equals((Object)this.valueAndType.type)) {
            if (pR.getOrganization().getResource() instanceof Organization) {
                Organization o = (Organization)pR.getOrganization().getResource();
                return o.getIdentifier().stream().anyMatch(i -> AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier, i));
            }
            return false;
        }
        String ref = pR.getOrganization().getReference();
        switch (this.valueAndType.type) {
            case ID: {
                return ref.equals("Organization/" + this.valueAndType.id);
            }
            case RESOURCE_NAME_AND_ID: {
                return ref.equals(this.valueAndType.resourceName + "/" + this.valueAndType.id);
            }
            case URL: {
                return ref.equals(this.valueAndType.url);
            }
        }
        return false;
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "practitioner_role->'organization'->>'reference'";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (includeParts.matches(RESOURCE_TYPE_NAME, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME)) {
            return "(SELECT jsonb_build_array(organization) FROM current_organizations WHERE concat('Organization/', organization->>'id') = practitioner_role->'organization'->>'reference') AS organizations";
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

