/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractBooleanParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="active", definition="http://hl7.org/fhir/SearchParameter/Practitioner-active", type=Enumerations.SearchParamType.TOKEN, documentation="Whether the practitioner record is active [true|false]")
public class PractitionerActive
extends AbstractBooleanParameter<Practitioner> {
    public static final String PARAMETER_NAME = "active";

    public PractitionerActive() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return "(practitioner->>'active')::BOOLEAN = ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setBoolean(parameterIndex, this.value);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Practitioner)) {
            return false;
        }
        Practitioner p = (Practitioner)resource;
        return p.getActive() == this.value.booleanValue();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(practitioner->>'active')::BOOLEAN" + sortDirectionWithSpacePrefix;
    }
}

