/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="type", definition="http://hl7.org/fhir/SearchParameter/Organization-type", type=Enumerations.SearchParamType.TOKEN, documentation="A code for the type of organization")
public class OrganizationType
extends AbstractTokenParameter<Organization> {
    public static final String PARAMETER_NAME = "type";
    public static final String RESOURCE_COLUMN = "organization";

    public OrganizationType() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case CODE: 
            case CODE_AND_SYSTEM: 
            case SYSTEM: {
                if (this.valueAndType.negated) {
                    return "NOT ((SELECT jsonb_agg(coding) FROM jsonb_array_elements(organization->'type') AS type, jsonb_array_elements(type->'coding') AS coding) @> ?::jsonb)";
                }
                return "(SELECT jsonb_agg(coding) FROM jsonb_array_elements(organization->'type') AS type, jsonb_array_elements(type->'coding') AS coding) @> ?::jsonb";
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                if (this.valueAndType.negated) {
                    return "(SELECT COUNT(*) FROM jsonb_array_elements(organization->'type') AS type, jsonb_array_elements(type->'coding') AS coding WHERE coding->>'code' <> ? OR (coding ?? 'system')) > 0";
                }
                return "(SELECT COUNT(*) FROM jsonb_array_elements(organization->'type') AS type, jsonb_array_elements(type->'coding') AS coding WHERE coding->>'code' = ? AND NOT (coding ?? 'system')) > 0";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "[{\"code\": \"" + this.valueAndType.codeValue + "\"}]");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "[{\"code\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
        }
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT string_agg((coding->>'system')::text || (coding->>'code')::text, ' ') FROM jsonb_array_elements(organization->'type'->'coding') coding)" + sortDirectionWithSpacePrefix;
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)resource;
        return this.codingMatches(o.getType());
    }
}

