/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Location-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="An identifier for the location")
public class LocationIdentifier
extends AbstractIdentifierParameter<Location> {
    public static final String RESOURCE_COLUMN = "location";

    public LocationIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Location)) {
            return false;
        }
        Location l = (Location)resource;
        return this.identifierMatches(l.getIdentifier());
    }
}

