/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractBooleanParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="active", definition="http://hl7.org/fhir/SearchParameter/HealthcareService-active", type=Enumerations.SearchParamType.TOKEN, documentation="The Healthcare Service is currently marked as active [true|false]")
public class HealthcareServiceActive
extends AbstractBooleanParameter<HealthcareService> {
    public static final String PARAMETER_NAME = "active";

    public HealthcareServiceActive() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return "(healthcare_service->>'active')::BOOLEAN = ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setBoolean(parameterIndex, this.value);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof HealthcareService)) {
            return false;
        }
        HealthcareService h = (HealthcareService)resource;
        return h.getActive() == this.value.booleanValue();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(healthcare_service->>'active')::BOOLEAN" + sortDirectionWithSpacePrefix;
    }
}

